@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedInstanceLongTermRetentionPolicy].
 */
@PulumiTagMarker
public class ManagedInstanceLongTermRetentionPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedInstanceLongTermRetentionPolicyArgs =
        ManagedInstanceLongTermRetentionPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ManagedInstanceLongTermRetentionPolicyArgsBuilder.() -> Unit) {
        val builder = ManagedInstanceLongTermRetentionPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedInstanceLongTermRetentionPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedInstanceLongTermRetentionPolicy(builtJavaResource)
    }
}

/**
 * A long term retention policy.
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update the LTR policy for the managed database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstanceLongTermRetentionPolicy = new AzureNative.Sql.ManagedInstanceLongTermRetentionPolicy("managedInstanceLongTermRetentionPolicy", new()
 *     {
 *         DatabaseName = "testDatabase",
 *         ManagedInstanceName = "testInstance",
 *         MonthlyRetention = "P1Y",
 *         PolicyName = "default",
 *         ResourceGroupName = "testResourceGroup",
 *         WeekOfYear = 5,
 *         WeeklyRetention = "P1M",
 *         YearlyRetention = "P5Y",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstanceLongTermRetentionPolicy(ctx, "managedInstanceLongTermRetentionPolicy", &sql.ManagedInstanceLongTermRetentionPolicyArgs{
 * 			DatabaseName:        pulumi.String("testDatabase"),
 * 			ManagedInstanceName: pulumi.String("testInstance"),
 * 			MonthlyRetention:    pulumi.String("P1Y"),
 * 			PolicyName:          pulumi.String("default"),
 * 			ResourceGroupName:   pulumi.String("testResourceGroup"),
 * 			WeekOfYear:          pulumi.Int(5),
 * 			WeeklyRetention:     pulumi.String("P1M"),
 * 			YearlyRetention:     pulumi.String("P5Y"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicy;
 * import com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstanceLongTermRetentionPolicy = new ManagedInstanceLongTermRetentionPolicy("managedInstanceLongTermRetentionPolicy", ManagedInstanceLongTermRetentionPolicyArgs.builder()
 *             .databaseName("testDatabase")
 *             .managedInstanceName("testInstance")
 *             .monthlyRetention("P1Y")
 *             .policyName("default")
 *             .resourceGroupName("testResourceGroup")
 *             .weekOfYear(5)
 *             .weeklyRetention("P1M")
 *             .yearlyRetention("P5Y")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstanceLongTermRetentionPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/backupLongTermRetentionPolicies/{policyName}
 * ```
 */
public class ManagedInstanceLongTermRetentionPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicy,
) : KotlinCustomResource(javaResource, ManagedInstanceLongTermRetentionPolicyMapper) {
    /**
     * The monthly retention policy for an LTR backup in an ISO 8601 format.
     */
    public val monthlyRetention: Output<String>?
        get() = javaResource.monthlyRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The week of year to take the yearly backup in an ISO 8601 format.
     */
    public val weekOfYear: Output<Int>?
        get() = javaResource.weekOfYear().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The weekly retention policy for an LTR backup in an ISO 8601 format.
     */
    public val weeklyRetention: Output<String>?
        get() = javaResource.weeklyRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The yearly retention policy for an LTR backup in an ISO 8601 format.
     */
    public val yearlyRetention: Output<String>?
        get() = javaResource.yearlyRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ManagedInstanceLongTermRetentionPolicyMapper :
    ResourceMapper<ManagedInstanceLongTermRetentionPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ManagedInstanceLongTermRetentionPolicy =
        ManagedInstanceLongTermRetentionPolicy(
            javaResource as
                com.pulumi.azurenative.sql.ManagedInstanceLongTermRetentionPolicy,
        )
}

/**
 * @see [ManagedInstanceLongTermRetentionPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedInstanceLongTermRetentionPolicy].
 */
public suspend fun managedInstanceLongTermRetentionPolicy(
    name: String,
    block: suspend ManagedInstanceLongTermRetentionPolicyResourceBuilder.() -> Unit,
):
    ManagedInstanceLongTermRetentionPolicy {
    val builder = ManagedInstanceLongTermRetentionPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedInstanceLongTermRetentionPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedInstanceLongTermRetentionPolicy(name: String):
    ManagedInstanceLongTermRetentionPolicy {
    val builder = ManagedInstanceLongTermRetentionPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
