@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateEndpointPropertyResponse
import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateEndpointPropertyResponse.Companion.toKotlin as managedInstancePrivateEndpointPropertyResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse.Companion.toKotlin as managedInstancePrivateLinkServiceConnectionStatePropertyResponseToKotlin

/**
 * Builder for [ManagedInstancePrivateEndpointConnection].
 */
@PulumiTagMarker
public class ManagedInstancePrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedInstancePrivateEndpointConnectionArgs =
        ManagedInstancePrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ManagedInstancePrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = ManagedInstancePrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedInstancePrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedInstancePrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * A private endpoint connection
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstancePrivateEndpointConnection = new AzureNative.Sql.ManagedInstancePrivateEndpointConnection("managedInstancePrivateEndpointConnection", new()
 *     {
 *         ManagedInstanceName = "test-cl",
 *         PrivateEndpointConnectionName = "private-endpoint-connection-name",
 *         PrivateLinkServiceConnectionState = new AzureNative.Sql.Inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "Default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstancePrivateEndpointConnection(ctx, "managedInstancePrivateEndpointConnection", &sql.ManagedInstancePrivateEndpointConnectionArgs{
 * 			ManagedInstanceName:           pulumi.String("test-cl"),
 * 			PrivateEndpointConnectionName: pulumi.String("private-endpoint-connection-name"),
 * 			PrivateLinkServiceConnectionState: &sql.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnection;
 * import com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstancePrivateEndpointConnection = new ManagedInstancePrivateEndpointConnection("managedInstancePrivateEndpointConnection", ManagedInstancePrivateEndpointConnectionArgs.builder()
 *             .managedInstanceName("test-cl")
 *             .privateEndpointConnectionName("private-endpoint-connection-name")
 *             .privateLinkServiceConnectionState(ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs.builder()
 *                 .description("Approved by johndoe@contoso.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("Default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstancePrivateEndpointConnection private-endpoint-connection-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class ManagedInstancePrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnection,
) : KotlinCustomResource(javaResource, ManagedInstancePrivateEndpointConnectionMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Private endpoint which the connection belongs to.
     */
    public val privateEndpoint: Output<ManagedInstancePrivateEndpointPropertyResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedInstancePrivateEndpointPropertyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Connection State of the Private Endpoint Connection.
     */
    public val privateLinkServiceConnectionState:
        Output<ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedInstancePrivateLinkServiceConnectionStatePropertyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * State of the Private Endpoint Connection.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedInstancePrivateEndpointConnectionMapper :
    ResourceMapper<ManagedInstancePrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): ManagedInstancePrivateEndpointConnection =
        ManagedInstancePrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnection,
        )
}

/**
 * @see [ManagedInstancePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedInstancePrivateEndpointConnection].
 */
public suspend fun managedInstancePrivateEndpointConnection(
    name: String,
    block: suspend ManagedInstancePrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    ManagedInstancePrivateEndpointConnection {
    val builder = ManagedInstancePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedInstancePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedInstancePrivateEndpointConnection(name: String):
    ManagedInstancePrivateEndpointConnection {
    val builder = ManagedInstancePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
