@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.ManagedInstancePrivateEndpointPropertyArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ManagedInstancePrivateEndpointPropertyArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A private endpoint connection
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstancePrivateEndpointConnection = new AzureNative.Sql.ManagedInstancePrivateEndpointConnection("managedInstancePrivateEndpointConnection", new()
 *     {
 *         ManagedInstanceName = "test-cl",
 *         PrivateEndpointConnectionName = "private-endpoint-connection-name",
 *         PrivateLinkServiceConnectionState = new AzureNative.Sql.Inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "Default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstancePrivateEndpointConnection(ctx, "managedInstancePrivateEndpointConnection", &sql.ManagedInstancePrivateEndpointConnectionArgs{
 * 			ManagedInstanceName:           pulumi.String("test-cl"),
 * 			PrivateEndpointConnectionName: pulumi.String("private-endpoint-connection-name"),
 * 			PrivateLinkServiceConnectionState: &sql.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnection;
 * import com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstancePrivateEndpointConnection = new ManagedInstancePrivateEndpointConnection("managedInstancePrivateEndpointConnection", ManagedInstancePrivateEndpointConnectionArgs.builder()
 *             .managedInstanceName("test-cl")
 *             .privateEndpointConnectionName("private-endpoint-connection-name")
 *             .privateLinkServiceConnectionState(ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs.builder()
 *                 .description("Approved by johndoe@contoso.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("Default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstancePrivateEndpointConnection private-endpoint-connection-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property managedInstanceName The name of the managed instance.
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateEndpointConnectionName
 * @property privateLinkServiceConnectionState Connection State of the Private Endpoint Connection.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class ManagedInstancePrivateEndpointConnectionArgs(
    public val managedInstanceName: Output<String>? = null,
    public val privateEndpoint: Output<ManagedInstancePrivateEndpointPropertyArgs>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState:
    Output<ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnectionArgs =
        com.pulumi.azurenative.sql.ManagedInstancePrivateEndpointConnectionArgs.builder()
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstancePrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class ManagedInstancePrivateEndpointConnectionArgsBuilder internal constructor() {
    private var managedInstanceName: Output<String>? = null

    private var privateEndpoint: Output<ManagedInstancePrivateEndpointPropertyArgs>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState:
        Output<ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("wuxvjdskrxcshfyt")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("qosrwswsxdbixlbt")
    public suspend fun privateEndpoint(`value`: Output<ManagedInstancePrivateEndpointPropertyArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value
     */
    @JvmName("oxmnmhcuiykxudbf")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Connection State of the Private Endpoint Connection.
     */
    @JvmName("wgatdlwkmfforcsi")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("cypemnlqjggkjhtn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("nnblbqwmcgkgeebn")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("udgpahswkscacjnm")
    public suspend fun privateEndpoint(`value`: ManagedInstancePrivateEndpointPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Private endpoint which the connection belongs to.
     */
    @JvmName("qsevmudyhwkkpyhy")
    public suspend
    fun privateEndpoint(argument: suspend ManagedInstancePrivateEndpointPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedInstancePrivateEndpointPropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvxatfaopagpmfuo")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Connection State of the Private Endpoint Connection.
     */
    @JvmName("yssawxeynvmbwibu")
    public suspend
    fun privateLinkServiceConnectionState(`value`: ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Connection State of the Private Endpoint Connection.
     */
    @JvmName("evpqvfikjacthjnd")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ManagedInstancePrivateLinkServiceConnectionStatePropertyArgsBuilder.() -> Unit) {
        val toBeMapped =
            ManagedInstancePrivateLinkServiceConnectionStatePropertyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("pbbanqmjvwkrvpfu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagedInstancePrivateEndpointConnectionArgs =
        ManagedInstancePrivateEndpointConnectionArgs(
            managedInstanceName = managedInstanceName,
            privateEndpoint = privateEndpoint,
            privateEndpointConnectionName = privateEndpointConnectionName,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            resourceGroupName = resourceGroupName,
        )
}
