@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.azurenative.sql.kotlin.outputs.ServerExternalAdministratorResponse
import com.pulumi.azurenative.sql.kotlin.outputs.ServerPrivateEndpointConnectionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.sql.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.ServerExternalAdministratorResponse.Companion.toKotlin as serverExternalAdministratorResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.ServerPrivateEndpointConnectionResponse.Companion.toKotlin as serverPrivateEndpointConnectionResponseToKotlin

/**
 * Builder for [Server].
 */
@PulumiTagMarker
public class ServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerArgs = ServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerArgsBuilder.() -> Unit) {
        val builder = ServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Server {
        val builtJavaResource = com.pulumi.azurenative.sql.Server(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Server(builtJavaResource)
    }
}

/**
 * An Azure SQL Database server.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.Sql.Server("server", new()
 *     {
 *         AdministratorLogin = "dummylogin",
 *         AdministratorLoginPassword = "PLACEHOLDER",
 *         Administrators = new AzureNative.Sql.Inputs.ServerExternalAdministratorArgs
 *         {
 *             AzureADOnlyAuthentication = true,
 *             Login = "bob@contoso.com",
 *             PrincipalType = AzureNative.Sql.PrincipalType.User,
 *             Sid = "00000011-1111-2222-2222-123456789111",
 *             TenantId = "00000011-1111-2222-2222-123456789111",
 *         },
 *         Location = "Japan East",
 *         PublicNetworkAccess = AzureNative.Sql.ServerNetworkAccessFlag.Enabled,
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         RestrictOutboundNetworkAccess = AzureNative.Sql.ServerNetworkAccessFlag.Enabled,
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServer(ctx, "server", &sql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("dummylogin"),
 * 			AdministratorLoginPassword: pulumi.String("PLACEHOLDER"),
 * 			Administrators: &sql.ServerExternalAdministratorArgs{
 * 				AzureADOnlyAuthentication: pulumi.Bool(true),
 * 				Login:                     pulumi.String("bob@contoso.com"),
 * 				PrincipalType:             pulumi.String(sql.PrincipalTypeUser),
 * 				Sid:                       pulumi.String("00000011-1111-2222-2222-123456789111"),
 * 				TenantId:                  pulumi.String("00000011-1111-2222-2222-123456789111"),
 * 			},
 * 			Location:                      pulumi.String("Japan East"),
 * 			PublicNetworkAccess:           pulumi.String(sql.ServerNetworkAccessFlagEnabled),
 * 			ResourceGroupName:             pulumi.String("sqlcrudtest-7398"),
 * 			RestrictOutboundNetworkAccess: pulumi.String(sql.ServerNetworkAccessFlagEnabled),
 * 			ServerName:                    pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Server;
 * import com.pulumi.azurenative.sql.ServerArgs;
 * import com.pulumi.azurenative.sql.inputs.ServerExternalAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("dummylogin")
 *             .administratorLoginPassword("PLACEHOLDER")
 *             .administrators(ServerExternalAdministratorArgs.builder()
 *                 .azureADOnlyAuthentication(true)
 *                 .login("bob@contoso.com")
 *                 .principalType("User")
 *                 .sid("00000011-1111-2222-2222-123456789111")
 *                 .tenantId("00000011-1111-2222-2222-123456789111")
 *                 .build())
 *             .location("Japan East")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .restrictOutboundNetworkAccess("Enabled")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:Server sqlcrudtest-4645 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}
 * ```
 */
public class Server internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.Server,
) : KotlinCustomResource(javaResource, ServerMapper) {
    /**
     * Administrator username for the server. Once created it cannot be changed.
     */
    public val administratorLogin: Output<String>?
        get() = javaResource.administratorLogin().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Azure Active Directory administrator of the server.
     */
    public val administrators: Output<ServerExternalAdministratorResponse>?
        get() = javaResource.administrators().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serverExternalAdministratorResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Client id used for cross tenant CMK scenario
     */
    public val federatedClientId: Output<String>?
        get() = javaResource.federatedClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The fully qualified domain name of the server.
     */
    public val fullyQualifiedDomainName: Output<String>
        get() = javaResource.fullyQualifiedDomainName().applyValue({ args0 -> args0 })

    /**
     * The Azure Active Directory identity of the server.
     */
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A CMK URI of the key to use for encryption.
     */
    public val keyId: Output<String>?
        get() = javaResource.keyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of sql server. This is metadata used for the Azure portal experience.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
     */
    public val minimalTlsVersion: Output<String>?
        get() = javaResource.minimalTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource id of a user assigned identity to be used by default.
     */
    public val primaryUserAssignedIdentityId: Output<String>?
        get() = javaResource.primaryUserAssignedIdentityId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of private endpoint connections on a server
     */
    public val privateEndpointConnections: Output<List<ServerPrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serverPrivateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Whether or not public endpoint access is allowed for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether or not to restrict outbound network access for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    public val restrictOutboundNetworkAccess: Output<String>?
        get() = javaResource.restrictOutboundNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the server.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The version of the server.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether or not existing server has a workspace created and if it allows connection from workspace
     */
    public val workspaceFeature: Output<String>
        get() = javaResource.workspaceFeature().applyValue({ args0 -> args0 })
}

public object ServerMapper : ResourceMapper<Server> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.Server::class == javaResource::class

    override fun map(javaResource: Resource): Server = Server(
        javaResource as
            com.pulumi.azurenative.sql.Server,
    )
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Server].
 */
public suspend fun server(name: String, block: suspend ServerResourceBuilder.() -> Unit): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 */
public fun server(name: String): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
