@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerCommunicationLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Server communication link.
 * Azure REST API version: 2014-04-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * ## Example Usage
 * ### Create a server communication link
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverCommunicationLink = new AzureNative.Sql.ServerCommunicationLink("serverCommunicationLink", new()
 *     {
 *         CommunicationLinkName = "link1",
 *         PartnerServer = "sqldcrudtest-test",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerCommunicationLink(ctx, "serverCommunicationLink", &sql.ServerCommunicationLinkArgs{
 * 			CommunicationLinkName: pulumi.String("link1"),
 * 			PartnerServer:         pulumi.String("sqldcrudtest-test"),
 * 			ResourceGroupName:     pulumi.String("sqlcrudtest-7398"),
 * 			ServerName:            pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerCommunicationLink;
 * import com.pulumi.azurenative.sql.ServerCommunicationLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverCommunicationLink = new ServerCommunicationLink("serverCommunicationLink", ServerCommunicationLinkArgs.builder()
 *             .communicationLinkName("link1")
 *             .partnerServer("sqldcrudtest-test")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerCommunicationLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}
 * ```
 * @property communicationLinkName The name of the server communication link.
 * @property partnerServer The name of the partner server.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class ServerCommunicationLinkArgs(
    public val communicationLinkName: Output<String>? = null,
    public val partnerServer: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerCommunicationLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerCommunicationLinkArgs =
        com.pulumi.azurenative.sql.ServerCommunicationLinkArgs.builder()
            .communicationLinkName(communicationLinkName?.applyValue({ args0 -> args0 }))
            .partnerServer(partnerServer?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerCommunicationLinkArgs].
 */
@PulumiTagMarker
public class ServerCommunicationLinkArgsBuilder internal constructor() {
    private var communicationLinkName: Output<String>? = null

    private var partnerServer: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of the server communication link.
     */
    @JvmName("tfuijhcacepfetbl")
    public suspend fun communicationLinkName(`value`: Output<String>) {
        this.communicationLinkName = value
    }

    /**
     * @param value The name of the partner server.
     */
    @JvmName("qnhagofaxpnifgbe")
    public suspend fun partnerServer(`value`: Output<String>) {
        this.partnerServer = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("mpnjviwtcywddnmb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("jqjtnpvlrqtxdcvw")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the server communication link.
     */
    @JvmName("vonxlgrictuwjoko")
    public suspend fun communicationLinkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communicationLinkName = mapped
    }

    /**
     * @param value The name of the partner server.
     */
    @JvmName("okowxockdwnggjtr")
    public suspend fun partnerServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerServer = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("iujpgvskqiryjycl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("dwsqfytoetkscyrh")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): ServerCommunicationLinkArgs = ServerCommunicationLinkArgs(
        communicationLinkName = communicationLinkName,
        partnerServer = partnerServer,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
