@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerTrustCertificate].
 */
@PulumiTagMarker
public class ServerTrustCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerTrustCertificateArgs = ServerTrustCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerTrustCertificateArgsBuilder.() -> Unit) {
        val builder = ServerTrustCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerTrustCertificate {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ServerTrustCertificate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerTrustCertificate(builtJavaResource)
    }
}

/**
 * Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create server trust certificate.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverTrustCertificate = new AzureNative.Sql.ServerTrustCertificate("serverTrustCertificate", new()
 *     {
 *         CertificateName = "customerCertificateName",
 *         ManagedInstanceName = "testcl",
 *         PublicBlob = "308203AE30820296A0030201020210",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerTrustCertificate(ctx, "serverTrustCertificate", &sql.ServerTrustCertificateArgs{
 * 			CertificateName:     pulumi.String("customerCertificateName"),
 * 			ManagedInstanceName: pulumi.String("testcl"),
 * 			PublicBlob:          pulumi.String("308203AE30820296A0030201020210"),
 * 			ResourceGroupName:   pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerTrustCertificate;
 * import com.pulumi.azurenative.sql.ServerTrustCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverTrustCertificate = new ServerTrustCertificate("serverTrustCertificate", ServerTrustCertificateArgs.builder()
 *             .certificateName("customerCertificateName")
 *             .managedInstanceName("testcl")
 *             .publicBlob("308203AE30820296A0030201020210")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerTrustCertificate customerCertificateName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/serverTrustCertificates/{certificateName}
 * ```
 */
public class ServerTrustCertificate internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ServerTrustCertificate,
) : KotlinCustomResource(javaResource, ServerTrustCertificateMapper) {
    /**
     * The certificate name
     */
    public val certificateName: Output<String>
        get() = javaResource.certificateName().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The certificate public blob
     */
    public val publicBlob: Output<String>?
        get() = javaResource.publicBlob().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The certificate thumbprint
     */
    public val thumbprint: Output<String>
        get() = javaResource.thumbprint().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerTrustCertificateMapper : ResourceMapper<ServerTrustCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ServerTrustCertificate::class == javaResource::class

    override fun map(javaResource: Resource): ServerTrustCertificate =
        ServerTrustCertificate(javaResource as com.pulumi.azurenative.sql.ServerTrustCertificate)
}

/**
 * @see [ServerTrustCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerTrustCertificate].
 */
public suspend fun serverTrustCertificate(
    name: String,
    block: suspend ServerTrustCertificateResourceBuilder.() -> Unit,
): ServerTrustCertificate {
    val builder = ServerTrustCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerTrustCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverTrustCertificate(name: String): ServerTrustCertificate {
    val builder = ServerTrustCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
