@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse
import com.pulumi.azurenative.sql.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerVulnerabilityAssessment].
 */
@PulumiTagMarker
public class ServerVulnerabilityAssessmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerVulnerabilityAssessmentArgs = ServerVulnerabilityAssessmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerVulnerabilityAssessmentArgsBuilder.() -> Unit) {
        val builder = ServerVulnerabilityAssessmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerVulnerabilityAssessment {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ServerVulnerabilityAssessment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerVulnerabilityAssessment(builtJavaResource)
    }
}

/**
 * A server vulnerability assessment.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a server's vulnerability assessment with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverVulnerabilityAssessment = new AzureNative.Sql.ServerVulnerabilityAssessment("serverVulnerabilityAssessment", new()
 *     {
 *         RecurringScans = new AzureNative.Sql.Inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
 *         {
 *             EmailSubscriptionAdmins = true,
 *             Emails = new[]
 *             {
 *                 "email1@mail.com",
 *                 "email2@mail.com",
 *             },
 *             IsEnabled = true,
 *         },
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         ServerName = "vulnerabilityaseessmenttest-6440",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerVulnerabilityAssessment(ctx, "serverVulnerabilityAssessment", &sql.ServerVulnerabilityAssessmentArgs{
 * 			RecurringScans: &sql.VulnerabilityAssessmentRecurringScansPropertiesArgs{
 * 				EmailSubscriptionAdmins: pulumi.Bool(true),
 * 				Emails: pulumi.StringArray{
 * 					pulumi.String("email1@mail.com"),
 * 					pulumi.String("email2@mail.com"),
 * 				},
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			ServerName:                  pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.sql.ServerVulnerabilityAssessmentArgs;
 * import com.pulumi.azurenative.sql.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverVulnerabilityAssessment = new ServerVulnerabilityAssessment("serverVulnerabilityAssessment", ServerVulnerabilityAssessmentArgs.builder()
 *             .recurringScans(VulnerabilityAssessmentRecurringScansPropertiesArgs.builder()
 *                 .emailSubscriptionAdmins(true)
 *                 .emails(
 *                     "email1@mail.com",
 *                     "email2@mail.com")
 *                 .isEnabled(true)
 *                 .build())
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .serverName("vulnerabilityaseessmenttest-6440")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a server's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverVulnerabilityAssessment = new AzureNative.Sql.ServerVulnerabilityAssessment("serverVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         ServerName = "vulnerabilityaseessmenttest-6440",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerVulnerabilityAssessment(ctx, "serverVulnerabilityAssessment", &sql.ServerVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			ServerName:                  pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.sql.ServerVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverVulnerabilityAssessment = new ServerVulnerabilityAssessment("serverVulnerabilityAssessment", ServerVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .serverName("vulnerabilityaseessmenttest-6440")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a server's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverVulnerabilityAssessment = new AzureNative.Sql.ServerVulnerabilityAssessment("serverVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         ServerName = "vulnerabilityaseessmenttest-6440",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerVulnerabilityAssessment(ctx, "serverVulnerabilityAssessment", &sql.ServerVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			ServerName:                  pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.sql.ServerVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverVulnerabilityAssessment = new ServerVulnerabilityAssessment("serverVulnerabilityAssessment", ServerVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .serverName("vulnerabilityaseessmenttest-6440")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}
 * ```
 */
public class ServerVulnerabilityAssessment internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ServerVulnerabilityAssessment,
) : KotlinCustomResource(javaResource, ServerVulnerabilityAssessmentMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The recurring scans settings
     */
    public val recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesResponse>?
        get() = javaResource.recurringScans().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerVulnerabilityAssessmentMapper : ResourceMapper<ServerVulnerabilityAssessment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ServerVulnerabilityAssessment::class == javaResource::class

    override fun map(javaResource: Resource): ServerVulnerabilityAssessment =
        ServerVulnerabilityAssessment(
            javaResource as
                com.pulumi.azurenative.sql.ServerVulnerabilityAssessment,
        )
}

/**
 * @see [ServerVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerVulnerabilityAssessment].
 */
public suspend fun serverVulnerabilityAssessment(
    name: String,
    block: suspend ServerVulnerabilityAssessmentResourceBuilder.() -> Unit,
):
    ServerVulnerabilityAssessment {
    val builder = ServerVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverVulnerabilityAssessment(name: String): ServerVulnerabilityAssessment {
    val builder = ServerVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
