@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.ScheduleItemResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.sql.kotlin.outputs.ScheduleItemResponse.Companion.toKotlin as scheduleItemResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StartStopManagedInstanceSchedule].
 */
@PulumiTagMarker
public class StartStopManagedInstanceScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StartStopManagedInstanceScheduleArgs = StartStopManagedInstanceScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StartStopManagedInstanceScheduleArgsBuilder.() -> Unit) {
        val builder = StartStopManagedInstanceScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StartStopManagedInstanceSchedule {
        val builtJavaResource =
            com.pulumi.azurenative.sql.StartStopManagedInstanceSchedule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StartStopManagedInstanceSchedule(builtJavaResource)
    }
}

/**
 * Managed instance's Start/Stop schedule.
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates or updates the managed instance's Start/Stop schedule with all optional parameters specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var startStopManagedInstanceSchedule = new AzureNative.Sql.StartStopManagedInstanceSchedule("startStopManagedInstanceSchedule", new()
 *     {
 *         Description = "This is a schedule for our Dev/Test environment.",
 *         ManagedInstanceName = "schedulemi",
 *         ResourceGroupName = "schedulerg",
 *         ScheduleList = new[]
 *         {
 *             new AzureNative.Sql.Inputs.ScheduleItemArgs
 *             {
 *                 StartDay = AzureNative.Sql.DayOfWeek.Thursday,
 *                 StartTime = "18:00",
 *                 StopDay = AzureNative.Sql.DayOfWeek.Thursday,
 *                 StopTime = "17:00",
 *             },
 *             new AzureNative.Sql.Inputs.ScheduleItemArgs
 *             {
 *                 StartDay = AzureNative.Sql.DayOfWeek.Thursday,
 *                 StartTime = "15:00",
 *                 StopDay = AzureNative.Sql.DayOfWeek.Thursday,
 *                 StopTime = "14:00",
 *             },
 *         },
 *         StartStopScheduleName = "default",
 *         TimeZoneId = "Central European Standard Time",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewStartStopManagedInstanceSchedule(ctx, "startStopManagedInstanceSchedule", &sql.StartStopManagedInstanceScheduleArgs{
 * 			Description:         pulumi.String("This is a schedule for our Dev/Test environment."),
 * 			ManagedInstanceName: pulumi.String("schedulemi"),
 * 			ResourceGroupName:   pulumi.String("schedulerg"),
 * 			ScheduleList: sql.ScheduleItemArray{
 * 				&sql.ScheduleItemArgs{
 * 					StartDay:  pulumi.String(sql.DayOfWeekThursday),
 * 					StartTime: pulumi.String("18:00"),
 * 					StopDay:   pulumi.String(sql.DayOfWeekThursday),
 * 					StopTime:  pulumi.String("17:00"),
 * 				},
 * 				&sql.ScheduleItemArgs{
 * 					StartDay:  pulumi.String(sql.DayOfWeekThursday),
 * 					StartTime: pulumi.String("15:00"),
 * 					StopDay:   pulumi.String(sql.DayOfWeekThursday),
 * 					StopTime:  pulumi.String("14:00"),
 * 				},
 * 			},
 * 			StartStopScheduleName: pulumi.String("default"),
 * 			TimeZoneId:            pulumi.String("Central European Standard Time"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.StartStopManagedInstanceSchedule;
 * import com.pulumi.azurenative.sql.StartStopManagedInstanceScheduleArgs;
 * import com.pulumi.azurenative.sql.inputs.ScheduleItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var startStopManagedInstanceSchedule = new StartStopManagedInstanceSchedule("startStopManagedInstanceSchedule", StartStopManagedInstanceScheduleArgs.builder()
 *             .description("This is a schedule for our Dev/Test environment.")
 *             .managedInstanceName("schedulemi")
 *             .resourceGroupName("schedulerg")
 *             .scheduleList(
 *                 ScheduleItemArgs.builder()
 *                     .startDay("Thursday")
 *                     .startTime("18:00")
 *                     .stopDay("Thursday")
 *                     .stopTime("17:00")
 *                     .build(),
 *                 ScheduleItemArgs.builder()
 *                     .startDay("Thursday")
 *                     .startTime("15:00")
 *                     .stopDay("Thursday")
 *                     .stopTime("14:00")
 *                     .build())
 *             .startStopScheduleName("default")
 *             .timeZoneId("Central European Standard Time")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates the managed instance's Start/Stop schedule with no optional parameters specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var startStopManagedInstanceSchedule = new AzureNative.Sql.StartStopManagedInstanceSchedule("startStopManagedInstanceSchedule", new()
 *     {
 *         ManagedInstanceName = "schedulemi",
 *         ResourceGroupName = "schedulerg",
 *         ScheduleList = new[]
 *         {
 *             new AzureNative.Sql.Inputs.ScheduleItemArgs
 *             {
 *                 StartDay = AzureNative.Sql.DayOfWeek.Thursday,
 *                 StartTime = "18:00",
 *                 StopDay = AzureNative.Sql.DayOfWeek.Thursday,
 *                 StopTime = "17:00",
 *             },
 *             new AzureNative.Sql.Inputs.ScheduleItemArgs
 *             {
 *                 StartDay = AzureNative.Sql.DayOfWeek.Thursday,
 *                 StartTime = "15:00",
 *                 StopDay = AzureNative.Sql.DayOfWeek.Thursday,
 *                 StopTime = "14:00",
 *             },
 *         },
 *         StartStopScheduleName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewStartStopManagedInstanceSchedule(ctx, "startStopManagedInstanceSchedule", &sql.StartStopManagedInstanceScheduleArgs{
 * 			ManagedInstanceName: pulumi.String("schedulemi"),
 * 			ResourceGroupName:   pulumi.String("schedulerg"),
 * 			ScheduleList: sql.ScheduleItemArray{
 * 				&sql.ScheduleItemArgs{
 * 					StartDay:  pulumi.String(sql.DayOfWeekThursday),
 * 					StartTime: pulumi.String("18:00"),
 * 					StopDay:   pulumi.String(sql.DayOfWeekThursday),
 * 					StopTime:  pulumi.String("17:00"),
 * 				},
 * 				&sql.ScheduleItemArgs{
 * 					StartDay:  pulumi.String(sql.DayOfWeekThursday),
 * 					StartTime: pulumi.String("15:00"),
 * 					StopDay:   pulumi.String(sql.DayOfWeekThursday),
 * 					StopTime:  pulumi.String("14:00"),
 * 				},
 * 			},
 * 			StartStopScheduleName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.StartStopManagedInstanceSchedule;
 * import com.pulumi.azurenative.sql.StartStopManagedInstanceScheduleArgs;
 * import com.pulumi.azurenative.sql.inputs.ScheduleItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var startStopManagedInstanceSchedule = new StartStopManagedInstanceSchedule("startStopManagedInstanceSchedule", StartStopManagedInstanceScheduleArgs.builder()
 *             .managedInstanceName("schedulemi")
 *             .resourceGroupName("schedulerg")
 *             .scheduleList(
 *                 ScheduleItemArgs.builder()
 *                     .startDay("Thursday")
 *                     .startTime("18:00")
 *                     .stopDay("Thursday")
 *                     .stopTime("17:00")
 *                     .build(),
 *                 ScheduleItemArgs.builder()
 *                     .startDay("Thursday")
 *                     .startTime("15:00")
 *                     .stopDay("Thursday")
 *                     .stopTime("14:00")
 *                     .build())
 *             .startStopScheduleName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:StartStopManagedInstanceSchedule default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/startStopSchedules/{startStopScheduleName}
 * ```
 */
public class StartStopManagedInstanceSchedule internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.StartStopManagedInstanceSchedule,
) : KotlinCustomResource(javaResource, StartStopManagedInstanceScheduleMapper) {
    /**
     * The description of the schedule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Timestamp when the next action will be executed in the corresponding schedule time zone.
     */
    public val nextExecutionTime: Output<String>
        get() = javaResource.nextExecutionTime().applyValue({ args0 -> args0 })

    /**
     * Next action to be executed (Start or Stop)
     */
    public val nextRunAction: Output<String>
        get() = javaResource.nextRunAction().applyValue({ args0 -> args0 })

    /**
     * Schedule list.
     */
    public val scheduleList: Output<List<ScheduleItemResponse>>
        get() = javaResource.scheduleList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    scheduleItemResponseToKotlin(args0)
                })
            })
        })

    /**
     * System data of the scheduled resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The time zone of the schedule.
     */
    public val timeZoneId: Output<String>?
        get() = javaResource.timeZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StartStopManagedInstanceScheduleMapper :
    ResourceMapper<StartStopManagedInstanceSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.StartStopManagedInstanceSchedule::class == javaResource::class

    override fun map(javaResource: Resource): StartStopManagedInstanceSchedule =
        StartStopManagedInstanceSchedule(
            javaResource as
                com.pulumi.azurenative.sql.StartStopManagedInstanceSchedule,
        )
}

/**
 * @see [StartStopManagedInstanceSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StartStopManagedInstanceSchedule].
 */
public suspend fun startStopManagedInstanceSchedule(
    name: String,
    block: suspend StartStopManagedInstanceScheduleResourceBuilder.() -> Unit,
):
    StartStopManagedInstanceSchedule {
    val builder = StartStopManagedInstanceScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StartStopManagedInstanceSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun startStopManagedInstanceSchedule(name: String): StartStopManagedInstanceSchedule {
    val builder = StartStopManagedInstanceScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
