@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SyncAgent].
 */
@PulumiTagMarker
public class SyncAgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SyncAgentArgs = SyncAgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SyncAgentArgsBuilder.() -> Unit) {
        val builder = SyncAgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SyncAgent {
        val builtJavaResource = com.pulumi.azurenative.sql.SyncAgent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SyncAgent(builtJavaResource)
    }
}

/**
 * An Azure SQL Database sync agent.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a new sync agent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncAgent = new AzureNative.Sql.SyncAgent("syncAgent", new()
 *     {
 *         ResourceGroupName = "syncagentcrud-65440",
 *         ServerName = "syncagentcrud-8475",
 *         SyncAgentName = "syncagentcrud-3187",
 *         SyncDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncAgent(ctx, "syncAgent", &sql.SyncAgentArgs{
 * 			ResourceGroupName: pulumi.String("syncagentcrud-65440"),
 * 			ServerName:        pulumi.String("syncagentcrud-8475"),
 * 			SyncAgentName:     pulumi.String("syncagentcrud-3187"),
 * 			SyncDatabaseId:    pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncAgent;
 * import com.pulumi.azurenative.sql.SyncAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncAgent = new SyncAgent("syncAgent", SyncAgentArgs.builder()
 *             .resourceGroupName("syncagentcrud-65440")
 *             .serverName("syncagentcrud-8475")
 *             .syncAgentName("syncagentcrud-3187")
 *             .syncDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a sync agent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncAgent = new AzureNative.Sql.SyncAgent("syncAgent", new()
 *     {
 *         ResourceGroupName = "syncagentcrud-65440",
 *         ServerName = "syncagentcrud-8475",
 *         SyncAgentName = "syncagentcrud-3187",
 *         SyncDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncAgent(ctx, "syncAgent", &sql.SyncAgentArgs{
 * 			ResourceGroupName: pulumi.String("syncagentcrud-65440"),
 * 			ServerName:        pulumi.String("syncagentcrud-8475"),
 * 			SyncAgentName:     pulumi.String("syncagentcrud-3187"),
 * 			SyncDatabaseId:    pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncAgent;
 * import com.pulumi.azurenative.sql.SyncAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncAgent = new SyncAgent("syncAgent", SyncAgentArgs.builder()
 *             .resourceGroupName("syncagentcrud-65440")
 *             .serverName("syncagentcrud-8475")
 *             .syncAgentName("syncagentcrud-3187")
 *             .syncDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:SyncAgent syncagent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}
 * ```
 */
public class SyncAgent internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.SyncAgent,
) : KotlinCustomResource(javaResource, SyncAgentMapper) {
    /**
     * Expiration time of the sync agent version.
     */
    public val expiryTime: Output<String>
        get() = javaResource.expiryTime().applyValue({ args0 -> args0 })

    /**
     * If the sync agent version is up to date.
     */
    public val isUpToDate: Output<Boolean>
        get() = javaResource.isUpToDate().applyValue({ args0 -> args0 })

    /**
     * Last alive time of the sync agent.
     */
    public val lastAliveTime: Output<String>
        get() = javaResource.lastAliveTime().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the sync agent.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * ARM resource id of the sync database in the sync agent.
     */
    public val syncDatabaseId: Output<String>?
        get() = javaResource.syncDatabaseId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the sync agent.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object SyncAgentMapper : ResourceMapper<SyncAgent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.SyncAgent::class == javaResource::class

    override fun map(javaResource: Resource): SyncAgent = SyncAgent(
        javaResource as
            com.pulumi.azurenative.sql.SyncAgent,
    )
}

/**
 * @see [SyncAgent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SyncAgent].
 */
public suspend fun syncAgent(name: String, block: suspend SyncAgentResourceBuilder.() -> Unit):
    SyncAgent {
    val builder = SyncAgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SyncAgent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun syncAgent(name: String): SyncAgent {
    val builder = SyncAgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
