@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SyncGroupSchemaResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.SyncGroupSchemaResponse.Companion.toKotlin as syncGroupSchemaResponseToKotlin

/**
 * Builder for [SyncGroup].
 */
@PulumiTagMarker
public class SyncGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SyncGroupArgs = SyncGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SyncGroupArgsBuilder.() -> Unit) {
        val builder = SyncGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SyncGroup {
        val builtJavaResource = com.pulumi.azurenative.sql.SyncGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SyncGroup(builtJavaResource)
    }
}

/**
 * An Azure SQL Database sync group.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a sync group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncGroup = new AzureNative.Sql.SyncGroup("syncGroup", new()
 *     {
 *         ConflictResolutionPolicy = AzureNative.Sql.SyncConflictResolutionPolicy.HubWin,
 *         DatabaseName = "syncgroupcrud-4328",
 *         HubDatabaseUserName = "hubUser",
 *         Interval = -1,
 *         ResourceGroupName = "syncgroupcrud-65440",
 *         ServerName = "syncgroupcrud-8475",
 *         SyncDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328",
 *         SyncGroupName = "syncgroupcrud-3187",
 *         UsePrivateLinkConnection = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncGroup(ctx, "syncGroup", &sql.SyncGroupArgs{
 * 			ConflictResolutionPolicy: pulumi.String(sql.SyncConflictResolutionPolicyHubWin),
 * 			DatabaseName:             pulumi.String("syncgroupcrud-4328"),
 * 			HubDatabaseUserName:      pulumi.String("hubUser"),
 * 			Interval:                 -1,
 * 			ResourceGroupName:        pulumi.String("syncgroupcrud-65440"),
 * 			ServerName:               pulumi.String("syncgroupcrud-8475"),
 * 			SyncDatabaseId:           pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
 * 			SyncGroupName:            pulumi.String("syncgroupcrud-3187"),
 * 			UsePrivateLinkConnection: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncGroup;
 * import com.pulumi.azurenative.sql.SyncGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncGroup = new SyncGroup("syncGroup", SyncGroupArgs.builder()
 *             .conflictResolutionPolicy("HubWin")
 *             .databaseName("syncgroupcrud-4328")
 *             .hubDatabaseUserName("hubUser")
 *             .interval("TODO: GenUnaryOpExpression")
 *             .resourceGroupName("syncgroupcrud-65440")
 *             .serverName("syncgroupcrud-8475")
 *             .syncDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328")
 *             .syncGroupName("syncgroupcrud-3187")
 *             .usePrivateLinkConnection(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Update a sync group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncGroup = new AzureNative.Sql.SyncGroup("syncGroup", new()
 *     {
 *         ConflictResolutionPolicy = AzureNative.Sql.SyncConflictResolutionPolicy.HubWin,
 *         DatabaseName = "syncgroupcrud-4328",
 *         HubDatabaseUserName = "hubUser",
 *         Interval = -1,
 *         ResourceGroupName = "syncgroupcrud-65440",
 *         ServerName = "syncgroupcrud-8475",
 *         SyncDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328",
 *         SyncGroupName = "syncgroupcrud-3187",
 *         UsePrivateLinkConnection = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncGroup(ctx, "syncGroup", &sql.SyncGroupArgs{
 * 			ConflictResolutionPolicy: pulumi.String(sql.SyncConflictResolutionPolicyHubWin),
 * 			DatabaseName:             pulumi.String("syncgroupcrud-4328"),
 * 			HubDatabaseUserName:      pulumi.String("hubUser"),
 * 			Interval:                 -1,
 * 			ResourceGroupName:        pulumi.String("syncgroupcrud-65440"),
 * 			ServerName:               pulumi.String("syncgroupcrud-8475"),
 * 			SyncDatabaseId:           pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
 * 			SyncGroupName:            pulumi.String("syncgroupcrud-3187"),
 * 			UsePrivateLinkConnection: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncGroup;
 * import com.pulumi.azurenative.sql.SyncGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncGroup = new SyncGroup("syncGroup", SyncGroupArgs.builder()
 *             .conflictResolutionPolicy("HubWin")
 *             .databaseName("syncgroupcrud-4328")
 *             .hubDatabaseUserName("hubUser")
 *             .interval("TODO: GenUnaryOpExpression")
 *             .resourceGroupName("syncgroupcrud-65440")
 *             .serverName("syncgroupcrud-8475")
 *             .syncDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-3521/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328")
 *             .syncGroupName("syncgroupcrud-3187")
 *             .usePrivateLinkConnection(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:SyncGroup syncgroupcrud-3187 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}
 * ```
 */
public class SyncGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.SyncGroup,
) : KotlinCustomResource(javaResource, SyncGroupMapper) {
    /**
     * Conflict logging retention period.
     */
    public val conflictLoggingRetentionInDays: Output<Int>?
        get() = javaResource.conflictLoggingRetentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Conflict resolution policy of the sync group.
     */
    public val conflictResolutionPolicy: Output<String>?
        get() = javaResource.conflictResolutionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If conflict logging is enabled.
     */
    public val enableConflictLogging: Output<Boolean>?
        get() = javaResource.enableConflictLogging().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User name for the sync group hub database credential.
     */
    public val hubDatabaseUserName: Output<String>?
        get() = javaResource.hubDatabaseUserName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sync interval of the sync group.
     */
    public val interval: Output<Int>?
        get() = javaResource.interval().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Last sync time of the sync group.
     */
    public val lastSyncTime: Output<String>
        get() = javaResource.lastSyncTime().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Private endpoint name of the sync group if use private link connection is enabled.
     */
    public val privateEndpointName: Output<String>
        get() = javaResource.privateEndpointName().applyValue({ args0 -> args0 })

    /**
     * Sync schema of the sync group.
     */
    public val schema: Output<SyncGroupSchemaResponse>?
        get() = javaResource.schema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    syncGroupSchemaResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name and capacity of the SKU.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ARM resource id of the sync database in the sync group.
     */
    public val syncDatabaseId: Output<String>?
        get() = javaResource.syncDatabaseId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sync state of the sync group.
     */
    public val syncState: Output<String>
        get() = javaResource.syncState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * If use private link connection is enabled.
     */
    public val usePrivateLinkConnection: Output<Boolean>?
        get() = javaResource.usePrivateLinkConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SyncGroupMapper : ResourceMapper<SyncGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.SyncGroup::class == javaResource::class

    override fun map(javaResource: Resource): SyncGroup = SyncGroup(
        javaResource as
            com.pulumi.azurenative.sql.SyncGroup,
    )
}

/**
 * @see [SyncGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SyncGroup].
 */
public suspend fun syncGroup(name: String, block: suspend SyncGroupResourceBuilder.() -> Unit):
    SyncGroup {
    val builder = SyncGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SyncGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun syncGroup(name: String): SyncGroup {
    val builder = SyncGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
