@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkloadClassifier].
 */
@PulumiTagMarker
public class WorkloadClassifierResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadClassifierArgs = WorkloadClassifierArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadClassifierArgsBuilder.() -> Unit) {
        val builder = WorkloadClassifierArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkloadClassifier {
        val builtJavaResource = com.pulumi.azurenative.sql.WorkloadClassifier(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkloadClassifier(builtJavaResource)
    }
}

/**
 * Workload classifier operations for a data warehouse
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a workload group with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadClassifier = new AzureNative.Sql.WorkloadClassifier("workloadClassifier", new()
 *     {
 *         Context = "test_context",
 *         DatabaseName = "testdb",
 *         EndTime = "14:00",
 *         Importance = "high",
 *         Label = "test_label",
 *         MemberName = "dbo",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         StartTime = "12:00",
 *         WorkloadClassifierName = "wlm_workloadclassifier",
 *         WorkloadGroupName = "wlm_workloadgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewWorkloadClassifier(ctx, "workloadClassifier", &sql.WorkloadClassifierArgs{
 * 			Context:                pulumi.String("test_context"),
 * 			DatabaseName:           pulumi.String("testdb"),
 * 			EndTime:                pulumi.String("14:00"),
 * 			Importance:             pulumi.String("high"),
 * 			Label:                  pulumi.String("test_label"),
 * 			MemberName:             pulumi.String("dbo"),
 * 			ResourceGroupName:      pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:             pulumi.String("testsvr"),
 * 			StartTime:              pulumi.String("12:00"),
 * 			WorkloadClassifierName: pulumi.String("wlm_workloadclassifier"),
 * 			WorkloadGroupName:      pulumi.String("wlm_workloadgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.WorkloadClassifier;
 * import com.pulumi.azurenative.sql.WorkloadClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadClassifier = new WorkloadClassifier("workloadClassifier", WorkloadClassifierArgs.builder()
 *             .context("test_context")
 *             .databaseName("testdb")
 *             .endTime("14:00")
 *             .importance("high")
 *             .label("test_label")
 *             .memberName("dbo")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .startTime("12:00")
 *             .workloadClassifierName("wlm_workloadclassifier")
 *             .workloadGroupName("wlm_workloadgroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workload group with the required properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadClassifier = new AzureNative.Sql.WorkloadClassifier("workloadClassifier", new()
 *     {
 *         DatabaseName = "testdb",
 *         MemberName = "dbo",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         WorkloadClassifierName = "wlm_workloadclassifier",
 *         WorkloadGroupName = "wlm_workloadgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewWorkloadClassifier(ctx, "workloadClassifier", &sql.WorkloadClassifierArgs{
 * 			DatabaseName:           pulumi.String("testdb"),
 * 			MemberName:             pulumi.String("dbo"),
 * 			ResourceGroupName:      pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:             pulumi.String("testsvr"),
 * 			WorkloadClassifierName: pulumi.String("wlm_workloadclassifier"),
 * 			WorkloadGroupName:      pulumi.String("wlm_workloadgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.WorkloadClassifier;
 * import com.pulumi.azurenative.sql.WorkloadClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadClassifier = new WorkloadClassifier("workloadClassifier", WorkloadClassifierArgs.builder()
 *             .databaseName("testdb")
 *             .memberName("dbo")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .workloadClassifierName("wlm_workloadclassifier")
 *             .workloadGroupName("wlm_workloadgroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:WorkloadClassifier wlm_workloadclassifier /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/workloadGroups/{workloadGroupName}/workloadClassifiers/{workloadClassifierName}
 * ```
 */
public class WorkloadClassifier internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.WorkloadClassifier,
) : KotlinCustomResource(javaResource, WorkloadClassifierMapper) {
    /**
     * The workload classifier context.
     */
    public val context: Output<String>?
        get() = javaResource.context().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The workload classifier end time for classification.
     */
    public val endTime: Output<String>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The workload classifier importance.
     */
    public val importance: Output<String>?
        get() = javaResource.importance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The workload classifier label.
     */
    public val label: Output<String>?
        get() = javaResource.label().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The workload classifier member name.
     */
    public val memberName: Output<String>
        get() = javaResource.memberName().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The workload classifier start time for classification.
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadClassifierMapper : ResourceMapper<WorkloadClassifier> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.WorkloadClassifier::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadClassifier = WorkloadClassifier(
        javaResource as
            com.pulumi.azurenative.sql.WorkloadClassifier,
    )
}

/**
 * @see [WorkloadClassifier].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadClassifier].
 */
public suspend fun workloadClassifier(
    name: String,
    block: suspend WorkloadClassifierResourceBuilder.() -> Unit,
): WorkloadClassifier {
    val builder = WorkloadClassifierResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadClassifier].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadClassifier(name: String): WorkloadClassifier {
    val builder = WorkloadClassifierResourceBuilder()
    builder.name(name)
    return builder.build()
}
