@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.WorkloadClassifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workload classifier operations for a data warehouse
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a workload group with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadClassifier = new AzureNative.Sql.WorkloadClassifier("workloadClassifier", new()
 *     {
 *         Context = "test_context",
 *         DatabaseName = "testdb",
 *         EndTime = "14:00",
 *         Importance = "high",
 *         Label = "test_label",
 *         MemberName = "dbo",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         StartTime = "12:00",
 *         WorkloadClassifierName = "wlm_workloadclassifier",
 *         WorkloadGroupName = "wlm_workloadgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewWorkloadClassifier(ctx, "workloadClassifier", &sql.WorkloadClassifierArgs{
 * 			Context:                pulumi.String("test_context"),
 * 			DatabaseName:           pulumi.String("testdb"),
 * 			EndTime:                pulumi.String("14:00"),
 * 			Importance:             pulumi.String("high"),
 * 			Label:                  pulumi.String("test_label"),
 * 			MemberName:             pulumi.String("dbo"),
 * 			ResourceGroupName:      pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:             pulumi.String("testsvr"),
 * 			StartTime:              pulumi.String("12:00"),
 * 			WorkloadClassifierName: pulumi.String("wlm_workloadclassifier"),
 * 			WorkloadGroupName:      pulumi.String("wlm_workloadgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.WorkloadClassifier;
 * import com.pulumi.azurenative.sql.WorkloadClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadClassifier = new WorkloadClassifier("workloadClassifier", WorkloadClassifierArgs.builder()
 *             .context("test_context")
 *             .databaseName("testdb")
 *             .endTime("14:00")
 *             .importance("high")
 *             .label("test_label")
 *             .memberName("dbo")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .startTime("12:00")
 *             .workloadClassifierName("wlm_workloadclassifier")
 *             .workloadGroupName("wlm_workloadgroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workload group with the required properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadClassifier = new AzureNative.Sql.WorkloadClassifier("workloadClassifier", new()
 *     {
 *         DatabaseName = "testdb",
 *         MemberName = "dbo",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         WorkloadClassifierName = "wlm_workloadclassifier",
 *         WorkloadGroupName = "wlm_workloadgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewWorkloadClassifier(ctx, "workloadClassifier", &sql.WorkloadClassifierArgs{
 * 			DatabaseName:           pulumi.String("testdb"),
 * 			MemberName:             pulumi.String("dbo"),
 * 			ResourceGroupName:      pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:             pulumi.String("testsvr"),
 * 			WorkloadClassifierName: pulumi.String("wlm_workloadclassifier"),
 * 			WorkloadGroupName:      pulumi.String("wlm_workloadgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.WorkloadClassifier;
 * import com.pulumi.azurenative.sql.WorkloadClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadClassifier = new WorkloadClassifier("workloadClassifier", WorkloadClassifierArgs.builder()
 *             .databaseName("testdb")
 *             .memberName("dbo")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .workloadClassifierName("wlm_workloadclassifier")
 *             .workloadGroupName("wlm_workloadgroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:WorkloadClassifier wlm_workloadclassifier /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/workloadGroups/{workloadGroupName}/workloadClassifiers/{workloadClassifierName}
 * ```
 * @property context The workload classifier context.
 * @property databaseName The name of the database.
 * @property endTime The workload classifier end time for classification.
 * @property importance The workload classifier importance.
 * @property label The workload classifier label.
 * @property memberName The workload classifier member name.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property startTime The workload classifier start time for classification.
 * @property workloadClassifierName The name of the workload classifier to create/update.
 * @property workloadGroupName The name of the workload group from which to receive the classifier from.
 */
public data class WorkloadClassifierArgs(
    public val context: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val endTime: Output<String>? = null,
    public val importance: Output<String>? = null,
    public val label: Output<String>? = null,
    public val memberName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val workloadClassifierName: Output<String>? = null,
    public val workloadGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.WorkloadClassifierArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.WorkloadClassifierArgs =
        com.pulumi.azurenative.sql.WorkloadClassifierArgs.builder()
            .context(context?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .importance(importance?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .memberName(memberName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .workloadClassifierName(workloadClassifierName?.applyValue({ args0 -> args0 }))
            .workloadGroupName(workloadGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadClassifierArgs].
 */
@PulumiTagMarker
public class WorkloadClassifierArgsBuilder internal constructor() {
    private var context: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var endTime: Output<String>? = null

    private var importance: Output<String>? = null

    private var label: Output<String>? = null

    private var memberName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var startTime: Output<String>? = null

    private var workloadClassifierName: Output<String>? = null

    private var workloadGroupName: Output<String>? = null

    /**
     * @param value The workload classifier context.
     */
    @JvmName("etmmpkhsaskkgdwr")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("ulryckjaananxlcu")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The workload classifier end time for classification.
     */
    @JvmName("fuwnahyunuqtylwt")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The workload classifier importance.
     */
    @JvmName("qberdmfpveotbpsr")
    public suspend fun importance(`value`: Output<String>) {
        this.importance = value
    }

    /**
     * @param value The workload classifier label.
     */
    @JvmName("pxwopkpuppkejcny")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The workload classifier member name.
     */
    @JvmName("fwpgjghkbgtcajmk")
    public suspend fun memberName(`value`: Output<String>) {
        this.memberName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("fbyleoutyfcaersk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("yowbelaxqhmtuctn")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The workload classifier start time for classification.
     */
    @JvmName("skycasdikjrnqyku")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The name of the workload classifier to create/update.
     */
    @JvmName("msqyhpihutbqxklp")
    public suspend fun workloadClassifierName(`value`: Output<String>) {
        this.workloadClassifierName = value
    }

    /**
     * @param value The name of the workload group from which to receive the classifier from.
     */
    @JvmName("gliiqvqialfqdglw")
    public suspend fun workloadGroupName(`value`: Output<String>) {
        this.workloadGroupName = value
    }

    /**
     * @param value The workload classifier context.
     */
    @JvmName("yifcykikuopkoohj")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("ysiqhocsdypuseci")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The workload classifier end time for classification.
     */
    @JvmName("pttcjlggisgduxtj")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The workload classifier importance.
     */
    @JvmName("bxrkpvxcdgxolvwb")
    public suspend fun importance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importance = mapped
    }

    /**
     * @param value The workload classifier label.
     */
    @JvmName("itsutdtflqljfhwi")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The workload classifier member name.
     */
    @JvmName("mqfjlvxfhncruvgy")
    public suspend fun memberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("bktqhgvgwhwthpeg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("gdueunwyegbvtgcx")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The workload classifier start time for classification.
     */
    @JvmName("obsdjkfxdgwqqnuo")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value The name of the workload classifier to create/update.
     */
    @JvmName("dluufnffcukbuvvs")
    public suspend fun workloadClassifierName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadClassifierName = mapped
    }

    /**
     * @param value The name of the workload group from which to receive the classifier from.
     */
    @JvmName("pkdytsxkatfomreo")
    public suspend fun workloadGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadGroupName = mapped
    }

    internal fun build(): WorkloadClassifierArgs = WorkloadClassifierArgs(
        context = context,
        databaseName = databaseName,
        endTime = endTime,
        importance = importance,
        label = label,
        memberName = memberName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        startTime = startTime,
        workloadClassifierName = workloadClassifierName,
        workloadGroupName = workloadGroupName,
    )
}
