@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
 */
public enum class BlobAuditingPolicyState(
    public val javaValue: com.pulumi.azurenative.sql.enums.BlobAuditingPolicyState,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.BlobAuditingPolicyState> {
    Enabled(com.pulumi.azurenative.sql.enums.BlobAuditingPolicyState.Enabled),
    Disabled(com.pulumi.azurenative.sql.enums.BlobAuditingPolicyState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.BlobAuditingPolicyState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.BlobAuditingPolicyState):
            BlobAuditingPolicyState =
            BlobAuditingPolicyState.values().first { it.javaValue == javaType }
    }
}
