@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
 */
public enum class IdentityType(
    public val javaValue: com.pulumi.azurenative.sql.enums.IdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.IdentityType> {
    None(com.pulumi.azurenative.sql.enums.IdentityType.None),
    SystemAssigned(com.pulumi.azurenative.sql.enums.IdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.sql.enums.IdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.sql.enums.IdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.IdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.IdentityType): IdentityType =
            IdentityType.values().first { it.javaValue == javaType }
    }
}
