@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price).
 */
public enum class InstancePoolLicenseType(
    public val javaValue: com.pulumi.azurenative.sql.enums.InstancePoolLicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.InstancePoolLicenseType> {
    LicenseIncluded(com.pulumi.azurenative.sql.enums.InstancePoolLicenseType.LicenseIncluded),
    BasePrice(com.pulumi.azurenative.sql.enums.InstancePoolLicenseType.BasePrice),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.InstancePoolLicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.InstancePoolLicenseType):
            InstancePoolLicenseType =
            InstancePoolLicenseType.values().first { it.javaValue == javaType }
    }
}
