@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
 */
public enum class ReplicationLinkType(
    public val javaValue: com.pulumi.azurenative.sql.enums.ReplicationLinkType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.ReplicationLinkType> {
    GEO(com.pulumi.azurenative.sql.enums.ReplicationLinkType.GEO),
    NAMED(com.pulumi.azurenative.sql.enums.ReplicationLinkType.NAMED),
    STANDBY(com.pulumi.azurenative.sql.enums.ReplicationLinkType.STANDBY),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.ReplicationLinkType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.ReplicationLinkType):
            ReplicationLinkType = ReplicationLinkType.values().first { it.javaValue == javaType }
    }
}
