@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The replication mode of a distributed availability group. Parameter will be ignored during link creation.
 */
public enum class ReplicationMode(
    public val javaValue: com.pulumi.azurenative.sql.enums.ReplicationMode,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.ReplicationMode> {
    Async(com.pulumi.azurenative.sql.enums.ReplicationMode.Async),
    Sync(com.pulumi.azurenative.sql.enums.ReplicationMode.Sync),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.ReplicationMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.ReplicationMode): ReplicationMode =
            ReplicationMode.values().first { it.javaValue == javaType }
    }
}
