@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The name of the sample schema to apply when creating this database.
 */
public enum class SampleName(
    public val javaValue: com.pulumi.azurenative.sql.enums.SampleName,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.SampleName> {
    AdventureWorksLT(com.pulumi.azurenative.sql.enums.SampleName.AdventureWorksLT),
    WideWorldImportersStd(com.pulumi.azurenative.sql.enums.SampleName.WideWorldImportersStd),
    WideWorldImportersFull(com.pulumi.azurenative.sql.enums.SampleName.WideWorldImportersFull),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.SampleName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.SampleName): SampleName =
            SampleName.values().first { it.javaValue == javaType }
    }
}
