@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database.
 */
public enum class SecurityAlertsPolicyState(
    public val javaValue: com.pulumi.azurenative.sql.enums.SecurityAlertsPolicyState,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.SecurityAlertsPolicyState> {
    Enabled(com.pulumi.azurenative.sql.enums.SecurityAlertsPolicyState.Enabled),
    Disabled(com.pulumi.azurenative.sql.enums.SecurityAlertsPolicyState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.SecurityAlertsPolicyState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.SecurityAlertsPolicyState):
            SecurityAlertsPolicyState =
            SecurityAlertsPolicyState.values().first { it.javaValue == javaType }
    }
}
