@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The server key type like 'ServiceManaged', 'AzureKeyVault'.
 */
public enum class ServerKeyType(
    public val javaValue: com.pulumi.azurenative.sql.enums.ServerKeyType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.ServerKeyType> {
    ServiceManaged(com.pulumi.azurenative.sql.enums.ServerKeyType.ServiceManaged),
    AzureKeyVault(com.pulumi.azurenative.sql.enums.ServerKeyType.AzureKeyVault),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.ServerKeyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.ServerKeyType): ServerKeyType =
            ServerKeyType.values().first { it.javaValue == javaType }
    }
}
