@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not to restrict outbound network access for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 */
public enum class ServerNetworkAccessFlag(
    public val javaValue: com.pulumi.azurenative.sql.enums.ServerNetworkAccessFlag,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.ServerNetworkAccessFlag> {
    Enabled(com.pulumi.azurenative.sql.enums.ServerNetworkAccessFlag.Enabled),
    Disabled(com.pulumi.azurenative.sql.enums.ServerNetworkAccessFlag.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.ServerNetworkAccessFlag = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.ServerNetworkAccessFlag):
            ServerNetworkAccessFlag =
            ServerNetworkAccessFlag.values().first { it.javaValue == javaType }
    }
}
