@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetExtendedDatabaseBlobAuditingPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blobAuditingPolicyName The name of the blob auditing policy.
 * @property databaseName The name of the database.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetExtendedDatabaseBlobAuditingPolicyPlainArgs(
    public val blobAuditingPolicyName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetExtendedDatabaseBlobAuditingPolicyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetExtendedDatabaseBlobAuditingPolicyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetExtendedDatabaseBlobAuditingPolicyPlainArgs.builder()
            .blobAuditingPolicyName(blobAuditingPolicyName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExtendedDatabaseBlobAuditingPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetExtendedDatabaseBlobAuditingPolicyPlainArgsBuilder internal constructor() {
    private var blobAuditingPolicyName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the blob auditing policy.
     */
    @JvmName("adoaajfqiwvhcogx")
    public suspend fun blobAuditingPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blobAuditingPolicyName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("epwariejxrxgghsr")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qlcsqswlukbjxldk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("doalkwqqixqwxtxh")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetExtendedDatabaseBlobAuditingPolicyPlainArgs =
        GetExtendedDatabaseBlobAuditingPolicyPlainArgs(
            blobAuditingPolicyName = blobAuditingPolicyName ?: throw
                PulumiNullFieldException("blobAuditingPolicyName"),
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        )
}
