@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetFailoverGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property failoverGroupName The name of the failover group.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server containing the failover group.
 */
public data class GetFailoverGroupPlainArgs(
    public val failoverGroupName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetFailoverGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetFailoverGroupPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetFailoverGroupPlainArgs.builder()
            .failoverGroupName(failoverGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFailoverGroupPlainArgs].
 */
@PulumiTagMarker
public class GetFailoverGroupPlainArgsBuilder internal constructor() {
    private var failoverGroupName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the failover group.
     */
    @JvmName("nkqvlrtwuevrrjyg")
    public suspend fun failoverGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.failoverGroupName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("umeiwvsspyjgjajg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server containing the failover group.
     */
    @JvmName("ldnvgttugvuvctvi")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetFailoverGroupPlainArgs = GetFailoverGroupPlainArgs(
        failoverGroupName = failoverGroupName ?: throw PulumiNullFieldException("failoverGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
