@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetInstancePoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instancePoolName The name of the instance pool to be retrieved.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetInstancePoolPlainArgs(
    public val instancePoolName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetInstancePoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetInstancePoolPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetInstancePoolPlainArgs.builder()
            .instancePoolName(instancePoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancePoolPlainArgs].
 */
@PulumiTagMarker
public class GetInstancePoolPlainArgsBuilder internal constructor() {
    private var instancePoolName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the instance pool to be retrieved.
     */
    @JvmName("weixhcjxsqarsipy")
    public suspend fun instancePoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instancePoolName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("riyctvwkugjvqoom")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInstancePoolPlainArgs = GetInstancePoolPlainArgs(
        instancePoolName = instancePoolName ?: throw PulumiNullFieldException("instancePoolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
