@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedInstanceAzureADOnlyAuthenticationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationName The name of server azure active directory only authentication.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetManagedInstanceAzureADOnlyAuthenticationPlainArgs(
    public val authenticationName: String,
    public val managedInstanceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedInstanceAzureADOnlyAuthenticationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetManagedInstanceAzureADOnlyAuthenticationPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedInstanceAzureADOnlyAuthenticationPlainArgs.builder()
            .authenticationName(authenticationName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedInstanceAzureADOnlyAuthenticationPlainArgs].
 */
@PulumiTagMarker
public class GetManagedInstanceAzureADOnlyAuthenticationPlainArgsBuilder internal constructor() {
    private var authenticationName: String? = null

    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of server azure active directory only authentication.
     */
    @JvmName("tinbtbbwotmifwxe")
    public suspend fun authenticationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("xurrbcxkrvfnqvsi")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rujiepalqoebqjyg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedInstanceAzureADOnlyAuthenticationPlainArgs =
        GetManagedInstanceAzureADOnlyAuthenticationPlainArgs(
            authenticationName = authenticationName ?: throw PulumiNullFieldException("authenticationName"),
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
