@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedInstanceLongTermRetentionPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database.
 * @property managedInstanceName The name of the managed instance.
 * @property policyName The policy name. Should always be Default.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetManagedInstanceLongTermRetentionPolicyPlainArgs(
    public val databaseName: String,
    public val managedInstanceName: String,
    public val policyName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedInstanceLongTermRetentionPolicyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetManagedInstanceLongTermRetentionPolicyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedInstanceLongTermRetentionPolicyPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .policyName(policyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedInstanceLongTermRetentionPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetManagedInstanceLongTermRetentionPolicyPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var managedInstanceName: String? = null

    private var policyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("qttfevjpofgqphjg")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("gevqpanqftrehjlc")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The policy name. Should always be Default.
     */
    @JvmName("llrpbytpbtshhhiw")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lountplccqcictwu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedInstanceLongTermRetentionPolicyPlainArgs =
        GetManagedInstanceLongTermRetentionPolicyPlainArgs(
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            policyName = policyName ?: throw PulumiNullFieldException("policyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
