@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetServerAzureADOnlyAuthenticationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationName The name of server azure active directory only authentication.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetServerAzureADOnlyAuthenticationPlainArgs(
    public val authenticationName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetServerAzureADOnlyAuthenticationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetServerAzureADOnlyAuthenticationPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetServerAzureADOnlyAuthenticationPlainArgs.builder()
            .authenticationName(authenticationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerAzureADOnlyAuthenticationPlainArgs].
 */
@PulumiTagMarker
public class GetServerAzureADOnlyAuthenticationPlainArgsBuilder internal constructor() {
    private var authenticationName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of server azure active directory only authentication.
     */
    @JvmName("unncwjyholotkped")
    public suspend fun authenticationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("cpvbbyapugeafxyy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("lkvkwoigeixwwspm")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetServerAzureADOnlyAuthenticationPlainArgs =
        GetServerAzureADOnlyAuthenticationPlainArgs(
            authenticationName = authenticationName ?: throw PulumiNullFieldException("authenticationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        )
}
