@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetStartStopManagedInstanceSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property startStopScheduleName Name of the managed instance Start/Stop schedule.
 */
public data class GetStartStopManagedInstanceSchedulePlainArgs(
    public val managedInstanceName: String,
    public val resourceGroupName: String,
    public val startStopScheduleName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetStartStopManagedInstanceSchedulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetStartStopManagedInstanceSchedulePlainArgs =
        com.pulumi.azurenative.sql.inputs.GetStartStopManagedInstanceSchedulePlainArgs.builder()
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .startStopScheduleName(startStopScheduleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStartStopManagedInstanceSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetStartStopManagedInstanceSchedulePlainArgsBuilder internal constructor() {
    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var startStopScheduleName: String? = null

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("bmvuhjejsbhmpufo")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xvfsisgnjajnlsqt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the managed instance Start/Stop schedule.
     */
    @JvmName("rynavyivukxmhvaf")
    public suspend fun startStopScheduleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.startStopScheduleName = mapped
    }

    internal fun build(): GetStartStopManagedInstanceSchedulePlainArgs =
        GetStartStopManagedInstanceSchedulePlainArgs(
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            startStopScheduleName = startStopScheduleName ?: throw
                PulumiNullFieldException("startStopScheduleName"),
        )
}
