@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetTransparentDataEncryptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the logical database for which the transparent data encryption is defined.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property tdeName The name of the transparent data encryption configuration.
 */
public data class GetTransparentDataEncryptionPlainArgs(
    public val databaseName: String,
    public val resourceGroupName: String,
    public val serverName: String,
    public val tdeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetTransparentDataEncryptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetTransparentDataEncryptionPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetTransparentDataEncryptionPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .tdeName(tdeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransparentDataEncryptionPlainArgs].
 */
@PulumiTagMarker
public class GetTransparentDataEncryptionPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var tdeName: String? = null

    /**
     * @param value The name of the logical database for which the transparent data encryption is defined.
     */
    @JvmName("wcbqmtvlwmtrocey")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("esfkpgmdqwquvftj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("lqqgnnauofuqyaxa")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the transparent data encryption configuration.
     */
    @JvmName("lfhtslekpjqhvvjq")
    public suspend fun tdeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tdeName = mapped
    }

    internal fun build(): GetTransparentDataEncryptionPlainArgs =
        GetTransparentDataEncryptionPlainArgs(
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
            tdeName = tdeName ?: throw PulumiNullFieldException("tdeName"),
        )
}
