@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.JobTargetArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.JobTargetGroupMembershipType
import com.pulumi.azurenative.sql.kotlin.enums.JobTargetType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A job target, for example a specific database or a container of databases that is evaluated during job execution.
 * @property databaseName The target database name.
 * @property elasticPoolName The target elastic pool name.
 * @property membershipType Whether the target is included or excluded from the group.
 * @property refreshCredential The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
 * @property serverName The target server name.
 * @property shardMapName The target shard map.
 * @property type The target type.
 */
public data class JobTargetArgs(
    public val databaseName: Output<String>? = null,
    public val elasticPoolName: Output<String>? = null,
    public val membershipType: Output<JobTargetGroupMembershipType>? = null,
    public val refreshCredential: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val shardMapName: Output<String>? = null,
    public val type: Output<Either<String, JobTargetType>>,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.JobTargetArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.JobTargetArgs =
        com.pulumi.azurenative.sql.inputs.JobTargetArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .elasticPoolName(elasticPoolName?.applyValue({ args0 -> args0 }))
            .membershipType(membershipType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .refreshCredential(refreshCredential?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .shardMapName(shardMapName?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobTargetArgs].
 */
@PulumiTagMarker
public class JobTargetArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var elasticPoolName: Output<String>? = null

    private var membershipType: Output<JobTargetGroupMembershipType>? = null

    private var refreshCredential: Output<String>? = null

    private var serverName: Output<String>? = null

    private var shardMapName: Output<String>? = null

    private var type: Output<Either<String, JobTargetType>>? = null

    /**
     * @param value The target database name.
     */
    @JvmName("dnhgwwqeevojtqal")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The target elastic pool name.
     */
    @JvmName("hychrdwmpionnsyl")
    public suspend fun elasticPoolName(`value`: Output<String>) {
        this.elasticPoolName = value
    }

    /**
     * @param value Whether the target is included or excluded from the group.
     */
    @JvmName("nwqujjgxbkjwikuu")
    public suspend fun membershipType(`value`: Output<JobTargetGroupMembershipType>) {
        this.membershipType = value
    }

    /**
     * @param value The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
     */
    @JvmName("dxebtjguaxxxsxla")
    public suspend fun refreshCredential(`value`: Output<String>) {
        this.refreshCredential = value
    }

    /**
     * @param value The target server name.
     */
    @JvmName("qumokytpykeranfs")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The target shard map.
     */
    @JvmName("wtjplgdfcayoiqyb")
    public suspend fun shardMapName(`value`: Output<String>) {
        this.shardMapName = value
    }

    /**
     * @param value The target type.
     */
    @JvmName("kmbjclrdwaxoyytu")
    public suspend fun type(`value`: Output<Either<String, JobTargetType>>) {
        this.type = value
    }

    /**
     * @param value The target database name.
     */
    @JvmName("yitbqddjavmguxlb")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The target elastic pool name.
     */
    @JvmName("ovvfxwmwvrfgoxsl")
    public suspend fun elasticPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticPoolName = mapped
    }

    /**
     * @param value Whether the target is included or excluded from the group.
     */
    @JvmName("mtqnrrohnyedrmsy")
    public suspend fun membershipType(`value`: JobTargetGroupMembershipType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.membershipType = mapped
    }

    /**
     * @param value The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
     */
    @JvmName("yjtgksqahxiafplv")
    public suspend fun refreshCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshCredential = mapped
    }

    /**
     * @param value The target server name.
     */
    @JvmName("abntaacppyikbiin")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The target shard map.
     */
    @JvmName("cildonceqjpnxspp")
    public suspend fun shardMapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardMapName = mapped
    }

    /**
     * @param value The target type.
     */
    @JvmName("jodlrjgkmytldsgx")
    public suspend fun type(`value`: Either<String, JobTargetType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The target type.
     */
    @JvmName("pivqmniyrwwijokv")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JobTargetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The target type.
     */
    @JvmName("hslfxprliqohtomt")
    public fun type(`value`: JobTargetType) {
        val toBeMapped = Either.ofRight<String, JobTargetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JobTargetArgs = JobTargetArgs(
        databaseName = databaseName,
        elasticPoolName = elasticPoolName,
        membershipType = membershipType,
        refreshCredential = refreshCredential,
        serverName = serverName,
        shardMapName = shardMapName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
