@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ManagedInstancePairInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Pairs of Managed Instances in the failover group.
 * @property partnerManagedInstanceId Id of Partner Managed Instance in pair.
 * @property primaryManagedInstanceId Id of Primary Managed Instance in pair.
 */
public data class ManagedInstancePairInfoArgs(
    public val partnerManagedInstanceId: Output<String>? = null,
    public val primaryManagedInstanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ManagedInstancePairInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.ManagedInstancePairInfoArgs =
        com.pulumi.azurenative.sql.inputs.ManagedInstancePairInfoArgs.builder()
            .partnerManagedInstanceId(partnerManagedInstanceId?.applyValue({ args0 -> args0 }))
            .primaryManagedInstanceId(primaryManagedInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstancePairInfoArgs].
 */
@PulumiTagMarker
public class ManagedInstancePairInfoArgsBuilder internal constructor() {
    private var partnerManagedInstanceId: Output<String>? = null

    private var primaryManagedInstanceId: Output<String>? = null

    /**
     * @param value Id of Partner Managed Instance in pair.
     */
    @JvmName("tjlarcfdaawsygsw")
    public suspend fun partnerManagedInstanceId(`value`: Output<String>) {
        this.partnerManagedInstanceId = value
    }

    /**
     * @param value Id of Primary Managed Instance in pair.
     */
    @JvmName("tqaonrersjeuvobo")
    public suspend fun primaryManagedInstanceId(`value`: Output<String>) {
        this.primaryManagedInstanceId = value
    }

    /**
     * @param value Id of Partner Managed Instance in pair.
     */
    @JvmName("vjqabyhwilchswij")
    public suspend fun partnerManagedInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerManagedInstanceId = mapped
    }

    /**
     * @param value Id of Primary Managed Instance in pair.
     */
    @JvmName("esrflhgkfebsxbar")
    public suspend fun primaryManagedInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryManagedInstanceId = mapped
    }

    internal fun build(): ManagedInstancePairInfoArgs = ManagedInstancePairInfoArgs(
        partnerManagedInstanceId = partnerManagedInstanceId,
        primaryManagedInstanceId = primaryManagedInstanceId,
    )
}
