@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.PrivateLinkServiceConnectionStatePropertyArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.PrivateLinkServiceConnectionStateStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStatePropertyArgs(
    public val description: Output<String>,
    public val status: Output<Either<String, PrivateLinkServiceConnectionStateStatus>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.PrivateLinkServiceConnectionStatePropertyArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.PrivateLinkServiceConnectionStatePropertyArgs =
        com.pulumi.azurenative.sql.inputs.PrivateLinkServiceConnectionStatePropertyArgs.builder()
            .description(description.applyValue({ args0 -> args0 }))
            .status(
                status.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStatePropertyArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStatePropertyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateLinkServiceConnectionStateStatus>>? = null

    /**
     * @param value The private link service connection description.
     */
    @JvmName("jmvvrmpfcoiggfjy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("mekroropdrnkwqdq")
    public suspend
    fun status(`value`: Output<Either<String, PrivateLinkServiceConnectionStateStatus>>) {
        this.status = value
    }

    /**
     * @param value The private link service connection description.
     */
    @JvmName("chrsoelufpuluibf")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("wlcyexylejsdaicc")
    public suspend fun status(`value`: Either<String, PrivateLinkServiceConnectionStateStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("mppbmtmogrroexcr")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkServiceConnectionStateStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("iuqoqcpvrfcjradg")
    public fun status(`value`: PrivateLinkServiceConnectionStateStatus) {
        val toBeMapped = Either.ofRight<String, PrivateLinkServiceConnectionStateStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStatePropertyArgs =
        PrivateLinkServiceConnectionStatePropertyArgs(
            description = description ?: throw PulumiNullFieldException("description"),
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
