@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Contains information about a database Threat Detection policy.
 * @property disabledAlerts Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
 * @property emailAccountAdmins Specifies that the alert is sent to the account administrators.
 * @property emailAddresses Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
 * @property id Resource ID.
 * @property kind Resource kind.
 * @property location The geo-location where the resource lives
 * @property name Resource name.
 * @property retentionDays Specifies the number of days to keep in the Threat Detection audit logs.
 * @property state Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
 * @property storageEndpoint Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
 * @property type Resource type.
 * @property useServerDefault Specifies whether to use the default server policy.
 */
public data class GetDatabaseThreatDetectionPolicyResult(
    public val disabledAlerts: String? = null,
    public val emailAccountAdmins: String? = null,
    public val emailAddresses: String? = null,
    public val id: String,
    public val kind: String,
    public val location: String? = null,
    public val name: String,
    public val retentionDays: Int? = null,
    public val state: String,
    public val storageEndpoint: String? = null,
    public val type: String,
    public val useServerDefault: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetDatabaseThreatDetectionPolicyResult):
            GetDatabaseThreatDetectionPolicyResult = GetDatabaseThreatDetectionPolicyResult(
            disabledAlerts = javaType.disabledAlerts().map({ args0 -> args0 }).orElse(null),
            emailAccountAdmins = javaType.emailAccountAdmins().map({ args0 -> args0 }).orElse(null),
            emailAddresses = javaType.emailAddresses().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            retentionDays = javaType.retentionDays().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
            storageEndpoint = javaType.storageEndpoint().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useServerDefault = javaType.useServerDefault().map({ args0 -> args0 }).orElse(null),
        )
    }
}
