@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Azure SQL job agent.
 * @property databaseId Resource ID of the database to store job metadata in.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property sku The name and tier of the SKU.
 * @property state The state of the job agent.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetJobAgentResult(
    public val databaseId: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val sku: SkuResponse? = null,
    public val state: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetJobAgentResult):
            GetJobAgentResult = GetJobAgentResult(
            databaseId = javaType.databaseId(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
