@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Azure SQL managed instance administrator.
 * @property administratorType Type of the managed instance administrator.
 * @property id Resource ID.
 * @property login Login name of the managed instance administrator.
 * @property name Resource name.
 * @property sid SID (object ID) of the managed instance administrator.
 * @property tenantId Tenant ID of the managed instance administrator.
 * @property type Resource type.
 */
public data class GetManagedInstanceAdministratorResult(
    public val administratorType: String,
    public val id: String,
    public val login: String,
    public val name: String,
    public val sid: String,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetManagedInstanceAdministratorResult):
            GetManagedInstanceAdministratorResult = GetManagedInstanceAdministratorResult(
            administratorType = javaType.administratorType(),
            id = javaType.id(),
            login = javaType.login(),
            name = javaType.name(),
            sid = javaType.sid(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
