@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Managed instance's Start/Stop schedule.
 * @property description The description of the schedule.
 * @property id Resource ID.
 * @property name Resource name.
 * @property nextExecutionTime Timestamp when the next action will be executed in the corresponding schedule time zone.
 * @property nextRunAction Next action to be executed (Start or Stop)
 * @property scheduleList Schedule list.
 * @property systemData System data of the scheduled resource.
 * @property timeZoneId The time zone of the schedule.
 * @property type Resource type.
 */
public data class GetStartStopManagedInstanceScheduleResult(
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val nextExecutionTime: String,
    public val nextRunAction: String,
    public val scheduleList: List<ScheduleItemResponse>,
    public val systemData: SystemDataResponse,
    public val timeZoneId: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetStartStopManagedInstanceScheduleResult):
            GetStartStopManagedInstanceScheduleResult = GetStartStopManagedInstanceScheduleResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            nextExecutionTime = javaType.nextExecutionTime(),
            nextRunAction = javaType.nextRunAction(),
            scheduleList = javaType.scheduleList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ScheduleItemResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            timeZoneId = javaType.timeZoneId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
