@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Pairs of Managed Instances in the failover group.
 * @property partnerManagedInstanceId Id of Partner Managed Instance in pair.
 * @property primaryManagedInstanceId Id of Primary Managed Instance in pair.
 */
public data class ManagedInstancePairInfoResponse(
    public val partnerManagedInstanceId: String? = null,
    public val primaryManagedInstanceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.ManagedInstancePairInfoResponse):
            ManagedInstancePairInfoResponse = ManagedInstancePairInfoResponse(
            partnerManagedInstanceId = javaType.partnerManagedInstanceId().map({ args0 -> args0 }).orElse(null),
            primaryManagedInstanceId = javaType.primaryManagedInstanceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
