@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionsRequired The actions required for private link service connection.
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStatePropertyResponse(
    public val actionsRequired: String,
    public val description: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.PrivateLinkServiceConnectionStatePropertyResponse):
            PrivateLinkServiceConnectionStatePropertyResponse =
            PrivateLinkServiceConnectionStatePropertyResponse(
                actionsRequired = javaType.actionsRequired(),
                description = javaType.description(),
                status = javaType.status(),
            )
    }
}
