@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Contains information of estimated or observed impact on various metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action.
 * @property absoluteValue Gets the absolute value of this dimension if applicable. e.g., Number of Queries affected
 * @property changeValueAbsolute Gets the absolute change in the value of this dimension. e.g., Absolute Disk space change in Megabytes
 * @property changeValueRelative Gets the relative change in the value of this dimension. e.g., Relative Disk space change in Percentage
 * @property dimensionName Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
 * @property unit Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
 */
public data class RecommendedActionImpactRecordResponse(
    public val absoluteValue: Double,
    public val changeValueAbsolute: Double,
    public val changeValueRelative: Double,
    public val dimensionName: String,
    public val unit: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.RecommendedActionImpactRecordResponse):
            RecommendedActionImpactRecordResponse = RecommendedActionImpactRecordResponse(
            absoluteValue = javaType.absoluteValue(),
            changeValueAbsolute = javaType.changeValueAbsolute(),
            changeValueRelative = javaType.changeValueRelative(),
            dimensionName = javaType.dimensionName(),
            unit = javaType.unit(),
        )
    }
}
