@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Contains time series of various impacted metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action.
 * @property metricName Gets the name of the metric. e.g., CPU, Number of Queries.
 * @property startTime Gets the start time of time interval given by this MetricInfo.
 * @property timeGrain Gets the duration of time interval for the value given by this MetricInfo. e.g., PT1H (1 hour)
 * @property unit Gets the unit in which metric is measured. e.g., DTU, Frequency
 * @property value Gets the value of the metric in the time interval given by this MetricInfo.
 */
public data class RecommendedActionMetricInfoResponse(
    public val metricName: String,
    public val startTime: String,
    public val timeGrain: String,
    public val unit: String,
    public val `value`: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.RecommendedActionMetricInfoResponse):
            RecommendedActionMetricInfoResponse = RecommendedActionMetricInfoResponse(
            metricName = javaType.metricName(),
            startTime = javaType.startTime(),
            timeGrain = javaType.timeGrain(),
            unit = javaType.unit(),
            `value` = javaType.`value`(),
        )
    }
}
