@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin

import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroupArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.SqlVmGroupImageSku
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.WsfcDomainProfileArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.WsfcDomainProfileArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A SQL virtual machine group.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2017-03-01-preview.
 * Other available API versions: 2023-01-01-preview.
 * ## Example Usage
 * ### Creates or updates a SQL virtual machine group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachineGroup = new AzureNative.SqlVirtualMachine.SqlVirtualMachineGroup("sqlVirtualMachineGroup", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlImageOffer = "SQL2016-WS2016",
 *         SqlImageSku = AzureNative.SqlVirtualMachine.SqlVmGroupImageSku.Enterprise,
 *         SqlVirtualMachineGroupName = "testvmgroup",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *         WsfcDomainProfile = new AzureNative.SqlVirtualMachine.Inputs.WsfcDomainProfileArgs
 *         {
 *             ClusterBootstrapAccount = "testrpadmin",
 *             ClusterOperatorAccount = "testrp@testdomain.com",
 *             ClusterSubnetType = AzureNative.SqlVirtualMachine.ClusterSubnetType.MultiSubnet,
 *             DomainFqdn = "testdomain.com",
 *             OuPath = "OU=WSCluster,DC=testdomain,DC=com",
 *             SqlServiceAccount = "sqlservice@testdomain.com",
 *             StorageAccountPrimaryKey = "<primary storage access key>",
 *             StorageAccountUrl = "https://storgact.blob.core.windows.net/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachineGroup(ctx, "sqlVirtualMachineGroup", &sqlvirtualmachine.SqlVirtualMachineGroupArgs{
 * 			Location:                   pulumi.String("northeurope"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			SqlImageOffer:              pulumi.String("SQL2016-WS2016"),
 * 			SqlImageSku:                pulumi.String(sqlvirtualmachine.SqlVmGroupImageSkuEnterprise),
 * 			SqlVirtualMachineGroupName: pulumi.String("testvmgroup"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 			WsfcDomainProfile: &sqlvirtualmachine.WsfcDomainProfileArgs{
 * 				ClusterBootstrapAccount:  pulumi.String("testrpadmin"),
 * 				ClusterOperatorAccount:   pulumi.String("testrp@testdomain.com"),
 * 				ClusterSubnetType:        pulumi.String(sqlvirtualmachine.ClusterSubnetTypeMultiSubnet),
 * 				DomainFqdn:               pulumi.String("testdomain.com"),
 * 				OuPath:                   pulumi.String("OU=WSCluster,DC=testdomain,DC=com"),
 * 				SqlServiceAccount:        pulumi.String("sqlservice@testdomain.com"),
 * 				StorageAccountPrimaryKey: pulumi.String("<primary storage access key>"),
 * 				StorageAccountUrl:        pulumi.String("https://storgact.blob.core.windows.net/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroup;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroupArgs;
 * import com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachineGroup = new SqlVirtualMachineGroup("sqlVirtualMachineGroup", SqlVirtualMachineGroupArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlImageOffer("SQL2016-WS2016")
 *             .sqlImageSku("Enterprise")
 *             .sqlVirtualMachineGroupName("testvmgroup")
 *             .tags(Map.of("mytag", "myval"))
 *             .wsfcDomainProfile(WsfcDomainProfileArgs.builder()
 *                 .clusterBootstrapAccount("testrpadmin")
 *                 .clusterOperatorAccount("testrp@testdomain.com")
 *                 .clusterSubnetType("MultiSubnet")
 *                 .domainFqdn("testdomain.com")
 *                 .ouPath("OU=WSCluster,DC=testdomain,DC=com")
 *                 .sqlServiceAccount("sqlservice@testdomain.com")
 *                 .storageAccountPrimaryKey("<primary storage access key>")
 *                 .storageAccountUrl("https://storgact.blob.core.windows.net/")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sqlvirtualmachine:SqlVirtualMachineGroup testvmgroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/{sqlVirtualMachineGroupName}
 * ```
 * @property location Resource location.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlImageOffer SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016.
 * @property sqlImageSku SQL image sku.
 * @property sqlVirtualMachineGroupName Name of the SQL virtual machine group.
 * @property tags Resource tags.
 * @property wsfcDomainProfile Cluster Active Directory domain profile.
 */
public data class SqlVirtualMachineGroupArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlImageOffer: Output<String>? = null,
    public val sqlImageSku: Output<Either<String, SqlVmGroupImageSku>>? = null,
    public val sqlVirtualMachineGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val wsfcDomainProfile: Output<WsfcDomainProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroupArgs =
        com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroupArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlImageOffer(sqlImageOffer?.applyValue({ args0 -> args0 }))
            .sqlImageSku(
                sqlImageSku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sqlVirtualMachineGroupName(sqlVirtualMachineGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .wsfcDomainProfile(
                wsfcDomainProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlVirtualMachineGroupArgs].
 */
@PulumiTagMarker
public class SqlVirtualMachineGroupArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlImageOffer: Output<String>? = null

    private var sqlImageSku: Output<Either<String, SqlVmGroupImageSku>>? = null

    private var sqlVirtualMachineGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var wsfcDomainProfile: Output<WsfcDomainProfileArgs>? = null

    /**
     * @param value Resource location.
     */
    @JvmName("srejjofvkusxgfss")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lfcnnasbayfmpsld")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016.
     */
    @JvmName("opailcakfvarbplx")
    public suspend fun sqlImageOffer(`value`: Output<String>) {
        this.sqlImageOffer = value
    }

    /**
     * @param value SQL image sku.
     */
    @JvmName("iedvjjbwagrlhicr")
    public suspend fun sqlImageSku(`value`: Output<Either<String, SqlVmGroupImageSku>>) {
        this.sqlImageSku = value
    }

    /**
     * @param value Name of the SQL virtual machine group.
     */
    @JvmName("vimydriggigmrqmo")
    public suspend fun sqlVirtualMachineGroupName(`value`: Output<String>) {
        this.sqlVirtualMachineGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qnxkiolbxljkentq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cluster Active Directory domain profile.
     */
    @JvmName("xubnwmxffoouimqa")
    public suspend fun wsfcDomainProfile(`value`: Output<WsfcDomainProfileArgs>) {
        this.wsfcDomainProfile = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("comprrwxqktmjvpx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("bethijpctjepwutt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016.
     */
    @JvmName("npkvnrhmgvlciqvn")
    public suspend fun sqlImageOffer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlImageOffer = mapped
    }

    /**
     * @param value SQL image sku.
     */
    @JvmName("boksesndpjfttmlm")
    public suspend fun sqlImageSku(`value`: Either<String, SqlVmGroupImageSku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlImageSku = mapped
    }

    /**
     * @param value SQL image sku.
     */
    @JvmName("qlxfcegdxrgknqym")
    public fun sqlImageSku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlVmGroupImageSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlImageSku = mapped
    }

    /**
     * @param value SQL image sku.
     */
    @JvmName("mjonjsohyqkhxrwn")
    public fun sqlImageSku(`value`: SqlVmGroupImageSku) {
        val toBeMapped = Either.ofRight<String, SqlVmGroupImageSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlImageSku = mapped
    }

    /**
     * @param value Name of the SQL virtual machine group.
     */
    @JvmName("wrcfrrumjjqbwlpc")
    public suspend fun sqlVirtualMachineGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlVirtualMachineGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wbdoqabtbudwctpx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("krgrfeytqkgqcwhn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Cluster Active Directory domain profile.
     */
    @JvmName("qyvpxwbyspobwvjc")
    public suspend fun wsfcDomainProfile(`value`: WsfcDomainProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wsfcDomainProfile = mapped
    }

    /**
     * @param argument Cluster Active Directory domain profile.
     */
    @JvmName("xbfjlmdytoriuhnb")
    public suspend fun wsfcDomainProfile(argument: suspend WsfcDomainProfileArgsBuilder.() -> Unit) {
        val toBeMapped = WsfcDomainProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.wsfcDomainProfile = mapped
    }

    internal fun build(): SqlVirtualMachineGroupArgs = SqlVirtualMachineGroupArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        sqlImageOffer = sqlImageOffer,
        sqlImageSku = sqlImageSku,
        sqlVirtualMachineGroupName = sqlVirtualMachineGroupName,
        tags = tags,
        wsfcDomainProfile = wsfcDomainProfile,
    )
}
