@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.GetAvailabilityGroupListenerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityGroupListenerName Name of the availability group listener.
 * @property expand The child resources to include in the response.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlVirtualMachineGroupName Name of the SQL virtual machine group.
 */
public data class GetAvailabilityGroupListenerPlainArgs(
    public val availabilityGroupListenerName: String,
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val sqlVirtualMachineGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.GetAvailabilityGroupListenerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.GetAvailabilityGroupListenerPlainArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.GetAvailabilityGroupListenerPlainArgs.builder()
            .availabilityGroupListenerName(availabilityGroupListenerName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlVirtualMachineGroupName(sqlVirtualMachineGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAvailabilityGroupListenerPlainArgs].
 */
@PulumiTagMarker
public class GetAvailabilityGroupListenerPlainArgsBuilder internal constructor() {
    private var availabilityGroupListenerName: String? = null

    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var sqlVirtualMachineGroupName: String? = null

    /**
     * @param value Name of the availability group listener.
     */
    @JvmName("urvtnkgmsypdqlvq")
    public suspend fun availabilityGroupListenerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.availabilityGroupListenerName = mapped
    }

    /**
     * @param value The child resources to include in the response.
     */
    @JvmName("lwcvljfhigjtswnu")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hyitortjpyxiqvgs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL virtual machine group.
     */
    @JvmName("pjursrqryibwdylo")
    public suspend fun sqlVirtualMachineGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlVirtualMachineGroupName = mapped
    }

    internal fun build(): GetAvailabilityGroupListenerPlainArgs =
        GetAvailabilityGroupListenerPlainArgs(
            availabilityGroupListenerName = availabilityGroupListenerName ?: throw
                PulumiNullFieldException("availabilityGroupListenerName"),
            expand = expand,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sqlVirtualMachineGroupName = sqlVirtualMachineGroupName ?: throw
                PulumiNullFieldException("sqlVirtualMachineGroupName"),
        )
}
