@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.GetSqlVirtualMachineGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlVirtualMachineGroupName Name of the SQL virtual machine group.
 */
public data class GetSqlVirtualMachineGroupPlainArgs(
    public val resourceGroupName: String,
    public val sqlVirtualMachineGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.GetSqlVirtualMachineGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.GetSqlVirtualMachineGroupPlainArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.GetSqlVirtualMachineGroupPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlVirtualMachineGroupName(sqlVirtualMachineGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlVirtualMachineGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSqlVirtualMachineGroupPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlVirtualMachineGroupName: String? = null

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vnqubpihxcjhofor")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL virtual machine group.
     */
    @JvmName("npuubrbxydpanpte")
    public suspend fun sqlVirtualMachineGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlVirtualMachineGroupName = mapped
    }

    internal fun build(): GetSqlVirtualMachineGroupPlainArgs = GetSqlVirtualMachineGroupPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlVirtualMachineGroupName = sqlVirtualMachineGroupName ?: throw
            PulumiNullFieldException("sqlVirtualMachineGroupName"),
    )
}
