@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlConnectivityUpdateSettingsArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.ConnectivityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Set the access level and network port settings for SQL Server.
 * @property connectivityType SQL Server connectivity option.
 * @property port SQL Server port.
 * @property sqlAuthUpdatePassword SQL Server sysadmin login password.
 * @property sqlAuthUpdateUserName SQL Server sysadmin login to create.
 */
public data class SqlConnectivityUpdateSettingsArgs(
    public val connectivityType: Output<Either<String, ConnectivityType>>? = null,
    public val port: Output<Int>? = null,
    public val sqlAuthUpdatePassword: Output<String>? = null,
    public val sqlAuthUpdateUserName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlConnectivityUpdateSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlConnectivityUpdateSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlConnectivityUpdateSettingsArgs.builder()
            .connectivityType(
                connectivityType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .sqlAuthUpdatePassword(sqlAuthUpdatePassword?.applyValue({ args0 -> args0 }))
            .sqlAuthUpdateUserName(sqlAuthUpdateUserName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlConnectivityUpdateSettingsArgs].
 */
@PulumiTagMarker
public class SqlConnectivityUpdateSettingsArgsBuilder internal constructor() {
    private var connectivityType: Output<Either<String, ConnectivityType>>? = null

    private var port: Output<Int>? = null

    private var sqlAuthUpdatePassword: Output<String>? = null

    private var sqlAuthUpdateUserName: Output<String>? = null

    /**
     * @param value SQL Server connectivity option.
     */
    @JvmName("vglvybechyqesxfe")
    public suspend fun connectivityType(`value`: Output<Either<String, ConnectivityType>>) {
        this.connectivityType = value
    }

    /**
     * @param value SQL Server port.
     */
    @JvmName("mjkwhtoskgruaqfj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value SQL Server sysadmin login password.
     */
    @JvmName("oeaarypnhsdylmsf")
    public suspend fun sqlAuthUpdatePassword(`value`: Output<String>) {
        this.sqlAuthUpdatePassword = value
    }

    /**
     * @param value SQL Server sysadmin login to create.
     */
    @JvmName("bkfxodvmkcvymxvp")
    public suspend fun sqlAuthUpdateUserName(`value`: Output<String>) {
        this.sqlAuthUpdateUserName = value
    }

    /**
     * @param value SQL Server connectivity option.
     */
    @JvmName("ojstknmluqhssmgk")
    public suspend fun connectivityType(`value`: Either<String, ConnectivityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectivityType = mapped
    }

    /**
     * @param value SQL Server connectivity option.
     */
    @JvmName("orgvpcxnqnowfalh")
    public fun connectivityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectivityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivityType = mapped
    }

    /**
     * @param value SQL Server connectivity option.
     */
    @JvmName("jxbdhggyahltkrqv")
    public fun connectivityType(`value`: ConnectivityType) {
        val toBeMapped = Either.ofRight<String, ConnectivityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivityType = mapped
    }

    /**
     * @param value SQL Server port.
     */
    @JvmName("tgtxgtolnqhpaabj")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value SQL Server sysadmin login password.
     */
    @JvmName("xgkhswykmgsdhrwk")
    public suspend fun sqlAuthUpdatePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlAuthUpdatePassword = mapped
    }

    /**
     * @param value SQL Server sysadmin login to create.
     */
    @JvmName("gijefdcxokujoglm")
    public suspend fun sqlAuthUpdateUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlAuthUpdateUserName = mapped
    }

    internal fun build(): SqlConnectivityUpdateSettingsArgs = SqlConnectivityUpdateSettingsArgs(
        connectivityType = connectivityType,
        port = port,
        sqlAuthUpdatePassword = sqlAuthUpdatePassword,
        sqlAuthUpdateUserName = sqlAuthUpdateUserName,
    )
}
