@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlWorkloadTypeUpdateSettingsArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.SqlWorkloadType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Set workload type to optimize storage for SQL Server.
 * @property sqlWorkloadType SQL Server workload type.
 */
public data class SqlWorkloadTypeUpdateSettingsArgs(
    public val sqlWorkloadType: Output<Either<String, SqlWorkloadType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlWorkloadTypeUpdateSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlWorkloadTypeUpdateSettingsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.SqlWorkloadTypeUpdateSettingsArgs.builder()
            .sqlWorkloadType(
                sqlWorkloadType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlWorkloadTypeUpdateSettingsArgs].
 */
@PulumiTagMarker
public class SqlWorkloadTypeUpdateSettingsArgsBuilder internal constructor() {
    private var sqlWorkloadType: Output<Either<String, SqlWorkloadType>>? = null

    /**
     * @param value SQL Server workload type.
     */
    @JvmName("rogaiqreqjpwndkc")
    public suspend fun sqlWorkloadType(`value`: Output<Either<String, SqlWorkloadType>>) {
        this.sqlWorkloadType = value
    }

    /**
     * @param value SQL Server workload type.
     */
    @JvmName("eduayypmpyvhrfbk")
    public suspend fun sqlWorkloadType(`value`: Either<String, SqlWorkloadType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlWorkloadType = mapped
    }

    /**
     * @param value SQL Server workload type.
     */
    @JvmName("ohmnxbkmxlgodxjx")
    public fun sqlWorkloadType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlWorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlWorkloadType = mapped
    }

    /**
     * @param value SQL Server workload type.
     */
    @JvmName("opwcltiqgrpirgms")
    public fun sqlWorkloadType(`value`: SqlWorkloadType) {
        val toBeMapped = Either.ofRight<String, SqlWorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlWorkloadType = mapped
    }

    internal fun build(): SqlWorkloadTypeUpdateSettingsArgs = SqlWorkloadTypeUpdateSettingsArgs(
        sqlWorkloadType = sqlWorkloadType,
    )
}
