@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainProfileArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.ClusterSubnetType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Active Directory account details to operate Windows Server Failover Cluster.
 * @property clusterBootstrapAccount Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
 * @property clusterOperatorAccount Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
 * @property clusterSubnetType Cluster subnet type.
 * @property domainFqdn Fully qualified name of the domain.
 * @property fileShareWitnessPath Optional path for fileshare witness.
 * @property ouPath Organizational Unit path in which the nodes and cluster will be present.
 * @property sqlServiceAccount Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
 * @property storageAccountPrimaryKey Primary key of the witness storage account.
 * @property storageAccountUrl Fully qualified ARM resource id of the witness storage account.
 */
public data class WsfcDomainProfileArgs(
    public val clusterBootstrapAccount: Output<String>? = null,
    public val clusterOperatorAccount: Output<String>? = null,
    public val clusterSubnetType: Output<Either<String, ClusterSubnetType>>? = null,
    public val domainFqdn: Output<String>? = null,
    public val fileShareWitnessPath: Output<String>? = null,
    public val ouPath: Output<String>? = null,
    public val sqlServiceAccount: Output<String>? = null,
    public val storageAccountPrimaryKey: Output<String>? = null,
    public val storageAccountUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainProfileArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.WsfcDomainProfileArgs.builder()
            .clusterBootstrapAccount(clusterBootstrapAccount?.applyValue({ args0 -> args0 }))
            .clusterOperatorAccount(clusterOperatorAccount?.applyValue({ args0 -> args0 }))
            .clusterSubnetType(
                clusterSubnetType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .domainFqdn(domainFqdn?.applyValue({ args0 -> args0 }))
            .fileShareWitnessPath(fileShareWitnessPath?.applyValue({ args0 -> args0 }))
            .ouPath(ouPath?.applyValue({ args0 -> args0 }))
            .sqlServiceAccount(sqlServiceAccount?.applyValue({ args0 -> args0 }))
            .storageAccountPrimaryKey(storageAccountPrimaryKey?.applyValue({ args0 -> args0 }))
            .storageAccountUrl(storageAccountUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WsfcDomainProfileArgs].
 */
@PulumiTagMarker
public class WsfcDomainProfileArgsBuilder internal constructor() {
    private var clusterBootstrapAccount: Output<String>? = null

    private var clusterOperatorAccount: Output<String>? = null

    private var clusterSubnetType: Output<Either<String, ClusterSubnetType>>? = null

    private var domainFqdn: Output<String>? = null

    private var fileShareWitnessPath: Output<String>? = null

    private var ouPath: Output<String>? = null

    private var sqlServiceAccount: Output<String>? = null

    private var storageAccountPrimaryKey: Output<String>? = null

    private var storageAccountUrl: Output<String>? = null

    /**
     * @param value Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
     */
    @JvmName("llyrabjeejgeyejy")
    public suspend fun clusterBootstrapAccount(`value`: Output<String>) {
        this.clusterBootstrapAccount = value
    }

    /**
     * @param value Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
     */
    @JvmName("vsyntgahtbqurobi")
    public suspend fun clusterOperatorAccount(`value`: Output<String>) {
        this.clusterOperatorAccount = value
    }

    /**
     * @param value Cluster subnet type.
     */
    @JvmName("aiiuxjnovhvhiiiy")
    public suspend fun clusterSubnetType(`value`: Output<Either<String, ClusterSubnetType>>) {
        this.clusterSubnetType = value
    }

    /**
     * @param value Fully qualified name of the domain.
     */
    @JvmName("wtaqdoxejahhytmp")
    public suspend fun domainFqdn(`value`: Output<String>) {
        this.domainFqdn = value
    }

    /**
     * @param value Optional path for fileshare witness.
     */
    @JvmName("mmbagxcpuppngsih")
    public suspend fun fileShareWitnessPath(`value`: Output<String>) {
        this.fileShareWitnessPath = value
    }

    /**
     * @param value Organizational Unit path in which the nodes and cluster will be present.
     */
    @JvmName("dmrcrtfcttdfiybp")
    public suspend fun ouPath(`value`: Output<String>) {
        this.ouPath = value
    }

    /**
     * @param value Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
     */
    @JvmName("uoptyxltakaayryl")
    public suspend fun sqlServiceAccount(`value`: Output<String>) {
        this.sqlServiceAccount = value
    }

    /**
     * @param value Primary key of the witness storage account.
     */
    @JvmName("lqfspxtbibwlexcw")
    public suspend fun storageAccountPrimaryKey(`value`: Output<String>) {
        this.storageAccountPrimaryKey = value
    }

    /**
     * @param value Fully qualified ARM resource id of the witness storage account.
     */
    @JvmName("skkjymribdweljue")
    public suspend fun storageAccountUrl(`value`: Output<String>) {
        this.storageAccountUrl = value
    }

    /**
     * @param value Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
     */
    @JvmName("lkxsibvglrghyatm")
    public suspend fun clusterBootstrapAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterBootstrapAccount = mapped
    }

    /**
     * @param value Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
     */
    @JvmName("xmdibeuxhtcuqank")
    public suspend fun clusterOperatorAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterOperatorAccount = mapped
    }

    /**
     * @param value Cluster subnet type.
     */
    @JvmName("mmqopgbxliychrtb")
    public suspend fun clusterSubnetType(`value`: Either<String, ClusterSubnetType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSubnetType = mapped
    }

    /**
     * @param value Cluster subnet type.
     */
    @JvmName("ixktsaxsjharhfmx")
    public fun clusterSubnetType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterSubnetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterSubnetType = mapped
    }

    /**
     * @param value Cluster subnet type.
     */
    @JvmName("uyrcyccafhhsgolr")
    public fun clusterSubnetType(`value`: ClusterSubnetType) {
        val toBeMapped = Either.ofRight<String, ClusterSubnetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterSubnetType = mapped
    }

    /**
     * @param value Fully qualified name of the domain.
     */
    @JvmName("pcsphbmjheoaggrc")
    public suspend fun domainFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainFqdn = mapped
    }

    /**
     * @param value Optional path for fileshare witness.
     */
    @JvmName("ranalwlwakabxtrx")
    public suspend fun fileShareWitnessPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileShareWitnessPath = mapped
    }

    /**
     * @param value Organizational Unit path in which the nodes and cluster will be present.
     */
    @JvmName("fdocvmakkinbrako")
    public suspend fun ouPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ouPath = mapped
    }

    /**
     * @param value Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
     */
    @JvmName("rugpakciqbmgwtao")
    public suspend fun sqlServiceAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServiceAccount = mapped
    }

    /**
     * @param value Primary key of the witness storage account.
     */
    @JvmName("fhhkpbcowtvuvxdg")
    public suspend fun storageAccountPrimaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountPrimaryKey = mapped
    }

    /**
     * @param value Fully qualified ARM resource id of the witness storage account.
     */
    @JvmName("jaooitddtvxwdbkm")
    public suspend fun storageAccountUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountUrl = mapped
    }

    internal fun build(): WsfcDomainProfileArgs = WsfcDomainProfileArgs(
        clusterBootstrapAccount = clusterBootstrapAccount,
        clusterOperatorAccount = clusterOperatorAccount,
        clusterSubnetType = clusterSubnetType,
        domainFqdn = domainFqdn,
        fileShareWitnessPath = fileShareWitnessPath,
        ouPath = ouPath,
        sqlServiceAccount = sqlServiceAccount,
        storageAccountPrimaryKey = storageAccountPrimaryKey,
        storageAccountUrl = storageAccountUrl,
    )
}
