@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A load balancer configuration for an availability group listener.
 * @property loadBalancerResourceId Resource id of the load balancer.
 * @property privateIpAddress Private IP address.
 * @property probePort Probe port.
 * @property publicIpAddressResourceId Resource id of the public IP.
 * @property sqlVirtualMachineInstances List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
 */
public data class LoadBalancerConfigurationResponse(
    public val loadBalancerResourceId: String? = null,
    public val privateIpAddress: PrivateIPAddressResponse? = null,
    public val probePort: Int? = null,
    public val publicIpAddressResourceId: String? = null,
    public val sqlVirtualMachineInstances: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.LoadBalancerConfigurationResponse):
            LoadBalancerConfigurationResponse = LoadBalancerConfigurationResponse(
            loadBalancerResourceId = javaType.loadBalancerResourceId().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.PrivateIPAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            probePort = javaType.probePort().map({ args0 -> args0 }).orElse(null),
            publicIpAddressResourceId = javaType.publicIpAddressResourceId().map({ args0 ->
                args0
            }).orElse(null),
            sqlVirtualMachineInstances = javaType.sqlVirtualMachineInstances().map({ args0 -> args0 }),
        )
    }
}
