@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin

import com.pulumi.azurenative.standbypool.StandbyContainerGroupPoolArgs.builder
import com.pulumi.azurenative.standbypool.kotlin.inputs.ContainerGroupPropertiesArgs
import com.pulumi.azurenative.standbypool.kotlin.inputs.ContainerGroupPropertiesArgsBuilder
import com.pulumi.azurenative.standbypool.kotlin.inputs.StandbyContainerGroupPoolElasticityProfileArgs
import com.pulumi.azurenative.standbypool.kotlin.inputs.StandbyContainerGroupPoolElasticityProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A StandbyContainerGroupPoolResource.
 * Azure REST API version: 2023-12-01-preview.
 * ## Example Usage
 * ### StandbyContainerGroupPools_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var standbyContainerGroupPool = new AzureNative.StandbyPool.StandbyContainerGroupPool("standbyContainerGroupPool", new()
 *     {
 *         ContainerGroupProperties = new AzureNative.StandbyPool.Inputs.ContainerGroupPropertiesArgs
 *         {
 *             ContainerGroupProfile = new AzureNative.StandbyPool.Inputs.ContainerGroupProfileArgs
 *             {
 *                 Id = "/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.ContainerInstance/containerGroupProfiles/cgProfile",
 *                 Revision = 1,
 *             },
 *             SubnetIds = new[]
 *             {
 *                 new AzureNative.StandbyPool.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/8cf6c1b6-c80f-437c-87ad-45fbaff54f73/resourceGroups/rgstandbypool/providers/Microsoft.Network/virtualNetworks/cgSubnet/subnets/cgSubnet",
 *                 },
 *             },
 *         },
 *         ElasticityProfile = new AzureNative.StandbyPool.Inputs.StandbyContainerGroupPoolElasticityProfileArgs
 *         {
 *             MaxReadyCapacity = 688,
 *             RefillPolicy = AzureNative.StandbyPool.RefillPolicy.Always,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rgstandbypool",
 *         StandbyContainerGroupPoolName = "pool",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/standbypool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := standbypool.NewStandbyContainerGroupPool(ctx, "standbyContainerGroupPool", &standbypool.StandbyContainerGroupPoolArgs{
 * 			ContainerGroupProperties: &standbypool.ContainerGroupPropertiesArgs{
 * 				ContainerGroupProfile: &standbypool.ContainerGroupProfileArgs{
 * 					Id:       pulumi.String("/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.ContainerInstance/containerGroupProfiles/cgProfile"),
 * 					Revision: pulumi.Float64(1),
 * 				},
 * 				SubnetIds: standbypool.SubnetArray{
 * 					&standbypool.SubnetArgs{
 * 						Id: pulumi.String("/subscriptions/8cf6c1b6-c80f-437c-87ad-45fbaff54f73/resourceGroups/rgstandbypool/providers/Microsoft.Network/virtualNetworks/cgSubnet/subnets/cgSubnet"),
 * 					},
 * 				},
 * 			},
 * 			ElasticityProfile: &standbypool.StandbyContainerGroupPoolElasticityProfileArgs{
 * 				MaxReadyCapacity: pulumi.Float64(688),
 * 				RefillPolicy:     pulumi.String(standbypool.RefillPolicyAlways),
 * 			},
 * 			Location:                      pulumi.String("West US"),
 * 			ResourceGroupName:             pulumi.String("rgstandbypool"),
 * 			StandbyContainerGroupPoolName: pulumi.String("pool"),
 * 			Tags:                          nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.standbypool.StandbyContainerGroupPool;
 * import com.pulumi.azurenative.standbypool.StandbyContainerGroupPoolArgs;
 * import com.pulumi.azurenative.standbypool.inputs.ContainerGroupPropertiesArgs;
 * import com.pulumi.azurenative.standbypool.inputs.ContainerGroupProfileArgs;
 * import com.pulumi.azurenative.standbypool.inputs.StandbyContainerGroupPoolElasticityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var standbyContainerGroupPool = new StandbyContainerGroupPool("standbyContainerGroupPool", StandbyContainerGroupPoolArgs.builder()
 *             .containerGroupProperties(ContainerGroupPropertiesArgs.builder()
 *                 .containerGroupProfile(ContainerGroupProfileArgs.builder()
 *                     .id("/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.ContainerInstance/containerGroupProfiles/cgProfile")
 *                     .revision(1)
 *                     .build())
 *                 .subnetIds(SubnetArgs.builder()
 *                     .id("/subscriptions/8cf6c1b6-c80f-437c-87ad-45fbaff54f73/resourceGroups/rgstandbypool/providers/Microsoft.Network/virtualNetworks/cgSubnet/subnets/cgSubnet")
 *                     .build())
 *                 .build())
 *             .elasticityProfile(StandbyContainerGroupPoolElasticityProfileArgs.builder()
 *                 .maxReadyCapacity(688)
 *                 .refillPolicy("always")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("rgstandbypool")
 *             .standbyContainerGroupPoolName("pool")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:standbypool:StandbyContainerGroupPool pool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyContainerGroupPools/{standbyContainerGroupPoolName}
 * ```
 * @property containerGroupProperties Specifies container group properties of standby container group pools.
 * @property elasticityProfile Specifies elasticity profile of standby container group pools.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property standbyContainerGroupPoolName Name of the standby container group pool
 * @property tags Resource tags.
 */
public data class StandbyContainerGroupPoolArgs(
    public val containerGroupProperties: Output<ContainerGroupPropertiesArgs>? = null,
    public val elasticityProfile: Output<StandbyContainerGroupPoolElasticityProfileArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val standbyContainerGroupPoolName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.standbypool.StandbyContainerGroupPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.standbypool.StandbyContainerGroupPoolArgs =
        com.pulumi.azurenative.standbypool.StandbyContainerGroupPoolArgs.builder()
            .containerGroupProperties(
                containerGroupProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .elasticityProfile(elasticityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .standbyContainerGroupPoolName(standbyContainerGroupPoolName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StandbyContainerGroupPoolArgs].
 */
@PulumiTagMarker
public class StandbyContainerGroupPoolArgsBuilder internal constructor() {
    private var containerGroupProperties: Output<ContainerGroupPropertiesArgs>? = null

    private var elasticityProfile: Output<StandbyContainerGroupPoolElasticityProfileArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var standbyContainerGroupPoolName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies container group properties of standby container group pools.
     */
    @JvmName("unkudaoykvdooklf")
    public suspend fun containerGroupProperties(`value`: Output<ContainerGroupPropertiesArgs>) {
        this.containerGroupProperties = value
    }

    /**
     * @param value Specifies elasticity profile of standby container group pools.
     */
    @JvmName("vxrdaoexihqawgyc")
    public suspend
    fun elasticityProfile(`value`: Output<StandbyContainerGroupPoolElasticityProfileArgs>) {
        this.elasticityProfile = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tgnsnoqcruqxhgix")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xvcytibxysokbsqf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the standby container group pool
     */
    @JvmName("tpavluddkltqmmkm")
    public suspend fun standbyContainerGroupPoolName(`value`: Output<String>) {
        this.standbyContainerGroupPoolName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jctvrcvpnnoefcwu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies container group properties of standby container group pools.
     */
    @JvmName("nikyadgjraypnwdr")
    public suspend fun containerGroupProperties(`value`: ContainerGroupPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerGroupProperties = mapped
    }

    /**
     * @param argument Specifies container group properties of standby container group pools.
     */
    @JvmName("gqqrgvkjxwptqhqk")
    public suspend
    fun containerGroupProperties(argument: suspend ContainerGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerGroupPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerGroupProperties = mapped
    }

    /**
     * @param value Specifies elasticity profile of standby container group pools.
     */
    @JvmName("dmbpvfkfklvufily")
    public suspend fun elasticityProfile(`value`: StandbyContainerGroupPoolElasticityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticityProfile = mapped
    }

    /**
     * @param argument Specifies elasticity profile of standby container group pools.
     */
    @JvmName("oxptmhsyjqlynrue")
    public suspend
    fun elasticityProfile(argument: suspend StandbyContainerGroupPoolElasticityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StandbyContainerGroupPoolElasticityProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.elasticityProfile = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yiaewtuaahruevkc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxgwltuctutpfjej")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the standby container group pool
     */
    @JvmName("yfbrfxatdnslgcif")
    public suspend fun standbyContainerGroupPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyContainerGroupPoolName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ackcptfoudgaifef")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xrbpnlgxyktssmdr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StandbyContainerGroupPoolArgs = StandbyContainerGroupPoolArgs(
        containerGroupProperties = containerGroupProperties,
        elasticityProfile = elasticityProfile,
        location = location,
        resourceGroupName = resourceGroupName,
        standbyContainerGroupPoolName = standbyContainerGroupPoolName,
        tags = tags,
    )
}
