@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin

import com.pulumi.azurenative.standbypool.StandbyVirtualMachinePoolArgs.builder
import com.pulumi.azurenative.standbypool.kotlin.enums.VirtualMachineState
import com.pulumi.azurenative.standbypool.kotlin.inputs.StandbyVirtualMachinePoolElasticityProfileArgs
import com.pulumi.azurenative.standbypool.kotlin.inputs.StandbyVirtualMachinePoolElasticityProfileArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A StandbyVirtualMachinePoolResource.
 * Azure REST API version: 2023-12-01-preview.
 * ## Example Usage
 * ### StandbyVirtualMachinePools_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var standbyVirtualMachinePool = new AzureNative.StandbyPool.StandbyVirtualMachinePool("standbyVirtualMachinePool", new()
 *     {
 *         AttachedVirtualMachineScaleSetId = "/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.Compute/virtualMachineScaleSets/myVmss",
 *         ElasticityProfile = new AzureNative.StandbyPool.Inputs.StandbyVirtualMachinePoolElasticityProfileArgs
 *         {
 *             MaxReadyCapacity = 304,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rgstandbypool",
 *         StandbyVirtualMachinePoolName = "pool",
 *         Tags = null,
 *         VirtualMachineState = AzureNative.StandbyPool.VirtualMachineState.Running,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/standbypool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := standbypool.NewStandbyVirtualMachinePool(ctx, "standbyVirtualMachinePool", &standbypool.StandbyVirtualMachinePoolArgs{
 * 			AttachedVirtualMachineScaleSetId: pulumi.String("/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.Compute/virtualMachineScaleSets/myVmss"),
 * 			ElasticityProfile: &standbypool.StandbyVirtualMachinePoolElasticityProfileArgs{
 * 				MaxReadyCapacity: pulumi.Float64(304),
 * 			},
 * 			Location:                      pulumi.String("West US"),
 * 			ResourceGroupName:             pulumi.String("rgstandbypool"),
 * 			StandbyVirtualMachinePoolName: pulumi.String("pool"),
 * 			Tags:                          nil,
 * 			VirtualMachineState:           pulumi.String(standbypool.VirtualMachineStateRunning),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.standbypool.StandbyVirtualMachinePool;
 * import com.pulumi.azurenative.standbypool.StandbyVirtualMachinePoolArgs;
 * import com.pulumi.azurenative.standbypool.inputs.StandbyVirtualMachinePoolElasticityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var standbyVirtualMachinePool = new StandbyVirtualMachinePool("standbyVirtualMachinePool", StandbyVirtualMachinePoolArgs.builder()
 *             .attachedVirtualMachineScaleSetId("/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.Compute/virtualMachineScaleSets/myVmss")
 *             .elasticityProfile(StandbyVirtualMachinePoolElasticityProfileArgs.builder()
 *                 .maxReadyCapacity(304)
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("rgstandbypool")
 *             .standbyVirtualMachinePoolName("pool")
 *             .tags()
 *             .virtualMachineState("Running")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:standbypool:StandbyVirtualMachinePool pool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}
 * ```
 * @property attachedVirtualMachineScaleSetId Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached to.
 * @property elasticityProfile Specifies the elasticity profile of the standby virtual machine pools.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property standbyVirtualMachinePoolName Name of the standby virtual machine pool
 * @property tags Resource tags.
 * @property virtualMachineState Specifies the desired state of virtual machines in the pool.
 */
public data class StandbyVirtualMachinePoolArgs(
    public val attachedVirtualMachineScaleSetId: Output<String>? = null,
    public val elasticityProfile: Output<StandbyVirtualMachinePoolElasticityProfileArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val standbyVirtualMachinePoolName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualMachineState: Output<Either<String, VirtualMachineState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.standbypool.StandbyVirtualMachinePoolArgs> {
    override fun toJava(): com.pulumi.azurenative.standbypool.StandbyVirtualMachinePoolArgs =
        com.pulumi.azurenative.standbypool.StandbyVirtualMachinePoolArgs.builder()
            .attachedVirtualMachineScaleSetId(attachedVirtualMachineScaleSetId?.applyValue({ args0 -> args0 }))
            .elasticityProfile(elasticityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .standbyVirtualMachinePoolName(standbyVirtualMachinePoolName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualMachineState(
                virtualMachineState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [StandbyVirtualMachinePoolArgs].
 */
@PulumiTagMarker
public class StandbyVirtualMachinePoolArgsBuilder internal constructor() {
    private var attachedVirtualMachineScaleSetId: Output<String>? = null

    private var elasticityProfile: Output<StandbyVirtualMachinePoolElasticityProfileArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var standbyVirtualMachinePoolName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualMachineState: Output<Either<String, VirtualMachineState>>? = null

    /**
     * @param value Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached to.
     */
    @JvmName("pjvhndcbrxkjqxho")
    public suspend fun attachedVirtualMachineScaleSetId(`value`: Output<String>) {
        this.attachedVirtualMachineScaleSetId = value
    }

    /**
     * @param value Specifies the elasticity profile of the standby virtual machine pools.
     */
    @JvmName("stiyvbmrvdxmmuxu")
    public suspend
    fun elasticityProfile(`value`: Output<StandbyVirtualMachinePoolElasticityProfileArgs>) {
        this.elasticityProfile = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("touottsccodjphuw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("okeiuqpuabeufsrx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the standby virtual machine pool
     */
    @JvmName("buuxrsyrjjhfsiyq")
    public suspend fun standbyVirtualMachinePoolName(`value`: Output<String>) {
        this.standbyVirtualMachinePoolName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iglyxokhnngvvvpj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the desired state of virtual machines in the pool.
     */
    @JvmName("ymmnqffkanafbtkh")
    public suspend fun virtualMachineState(`value`: Output<Either<String, VirtualMachineState>>) {
        this.virtualMachineState = value
    }

    /**
     * @param value Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached to.
     */
    @JvmName("gxndlqxjgyuvwkal")
    public suspend fun attachedVirtualMachineScaleSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedVirtualMachineScaleSetId = mapped
    }

    /**
     * @param value Specifies the elasticity profile of the standby virtual machine pools.
     */
    @JvmName("hsblgcmwcjmwyyud")
    public suspend fun elasticityProfile(`value`: StandbyVirtualMachinePoolElasticityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticityProfile = mapped
    }

    /**
     * @param argument Specifies the elasticity profile of the standby virtual machine pools.
     */
    @JvmName("gdxagjqangunwwet")
    public suspend
    fun elasticityProfile(argument: suspend StandbyVirtualMachinePoolElasticityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StandbyVirtualMachinePoolElasticityProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.elasticityProfile = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lfxwakearcvjjafl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cjjceutkktfykgfm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the standby virtual machine pool
     */
    @JvmName("ffdrwbisdfvfobhc")
    public suspend fun standbyVirtualMachinePoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyVirtualMachinePoolName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gofevuormkwrskcn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("uckhxqppalprbddt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the desired state of virtual machines in the pool.
     */
    @JvmName("xvjqhkaqrhwdsqty")
    public suspend fun virtualMachineState(`value`: Either<String, VirtualMachineState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineState = mapped
    }

    /**
     * @param value Specifies the desired state of virtual machines in the pool.
     */
    @JvmName("kksraqagmrjsdymt")
    public fun virtualMachineState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachineState = mapped
    }

    /**
     * @param value Specifies the desired state of virtual machines in the pool.
     */
    @JvmName("usgxqrndgykjxweo")
    public fun virtualMachineState(`value`: VirtualMachineState) {
        val toBeMapped = Either.ofRight<String, VirtualMachineState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachineState = mapped
    }

    internal fun build(): StandbyVirtualMachinePoolArgs = StandbyVirtualMachinePoolArgs(
        attachedVirtualMachineScaleSetId = attachedVirtualMachineScaleSetId,
        elasticityProfile = elasticityProfile,
        location = location,
        resourceGroupName = resourceGroupName,
        standbyVirtualMachinePoolName = standbyVirtualMachinePoolName,
        tags = tags,
        virtualMachineState = virtualMachineState,
    )
}
