@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the desired state of virtual machines in the pool.
 */
public enum class VirtualMachineState(
    public val javaValue: com.pulumi.azurenative.standbypool.enums.VirtualMachineState,
) : ConvertibleToJava<com.pulumi.azurenative.standbypool.enums.VirtualMachineState> {
    /**
     * The virtual machine is up and running.
     */
    Running(com.pulumi.azurenative.standbypool.enums.VirtualMachineState.Running),

    /**
     * The virtual machine has released the lease on the underlying hardware and is powered off.
     */
    Deallocated(com.pulumi.azurenative.standbypool.enums.VirtualMachineState.Deallocated),
    ;

    override fun toJava(): com.pulumi.azurenative.standbypool.enums.VirtualMachineState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.standbypool.enums.VirtualMachineState):
            VirtualMachineState = VirtualMachineState.values().first { it.javaValue == javaType }
    }
}
